/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.TypeScriptMethodDescriptor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSMethodDescriptorFactory {
    @NotNull
    public static JSMethodDescriptor create(@NotNull JSFunction method, boolean forceConstructor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptorFactory", "create"));
        }
        if (DialectDetector.isTypeScript((PsiElement)method)) {
            TypeScriptMethodDescriptor typeScriptMethodDescriptor = new TypeScriptMethodDescriptor(method, forceConstructor);
            if (typeScriptMethodDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptorFactory", "create"));
            }
            return typeScriptMethodDescriptor;
        }
        JSMethodDescriptor jSMethodDescriptor = new JSMethodDescriptor(method, forceConstructor);
        if (jSMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptorFactory", "create"));
        }
        return jSMethodDescriptor;
    }
}

