/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperClassDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class JSExtractSuperClassHandler
extends BaseJSRefactoringHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.superclass.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"error.wrong.caret.position.class");

    public JSExtractSuperClassHandler() {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperClassHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperClassHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        if (!this.checkEcma(element, (Editor)CommonDataKeys.EDITOR.getData(dataContext))) {
            return;
        }
        JSClass aClass = JSExtractSuperClassHandler.getClass(element);
        if (aClass != null) {
            if (aClass.isInterface()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface")), (String)REFACTORING_NAME, null);
            } else if (aClass instanceof XmlBackedJSClassImpl) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"superclass.cannot.be.extracted.from.mxml.component", (Object[])new Object[0])), (String)REFACTORING_NAME, null);
            } else {
                JSElement selected = element instanceof JSElement ? (JSElement)element : null;
                JSExtractSuperClassDialog dialog = new JSExtractSuperClassDialog(project, aClass, selected, REFACTORING_NAME);
                dialog.show();
            }
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON), (String)REFACTORING_NAME, null);
        }
    }
}

