/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class JSPullUpHelper {
    private static final Logger LOG = Logger.getInstance((String)JSPullUpHelper.class.getName());
    private final JSClass mySourceClass;
    private final JSClass myTargetClass;
    private final JSMemberInfo[] myMembersToMove;
    private final int myDocCommentPolicy;

    public JSPullUpHelper(JSClass sourceClass, JSClass targetSuperClass, JSMemberInfo[] membersToMove, int docCommentPolicy) {
        this.mySourceClass = sourceClass;
        this.myTargetClass = targetSuperClass;
        this.myMembersToMove = membersToMove;
        this.myDocCommentPolicy = docCommentPolicy;
    }

    public void moveMembersToBase() throws IncorrectOperationException {
        this.moveMembersToBase(new ArrayList<FormatFixer>(), true);
    }

    public Collection<JSElement> moveMembersToBase(List<FormatFixer> postponedFormatters, boolean allowFormat) throws IncorrectOperationException {
        boolean withMethodsAsdoc;
        Collection<PsiFile> filesWithUsages = JSRefactoringUtil.qualifyIncomingReferences(JSRefactoringUtil.getUsages(JSMemberInfo.getStatics(this.myMembersToMove), this.myTargetClass));
        HashSet<String> importsInTargetFile = new HashSet<String>();
        HashSet<String> namespacesInTargetFile = new HashSet<String>();
        ArrayList<JSAttributeListOwner> movedMembers = new ArrayList<JSAttributeListOwner>();
        for (JSMemberInfo info : this.myMembersToMove) {
            movedMembers.add((JSAttributeListOwner)info.getMember());
        }
        boolean bl = this.myTargetClass.isInterface() && !this.mySourceClass.isInterface() ? this.myDocCommentPolicy == 1 : (withMethodsAsdoc = true);
        if (!this.myTargetClass.isInterface() || this.mySourceClass.isInterface()) {
            JSRefactoringUtil.addRemovalFormatters(this.mySourceClass, movedMembers, (Condition<JSFunction>)(withMethodsAsdoc ? Conditions.alwaysTrue() : Conditions.alwaysFalse()), (Condition<JSVariable>)Conditions.alwaysTrue(), postponedFormatters);
        }
        for (JSMemberInfo info : this.myMembersToMove) {
            if (info.getMember() instanceof JSClass) continue;
            JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
            if (!this.myTargetClass.isInterface() && member.getAttributeList().getNamespace() == null) {
                JSAttributeList.AccessType accessType = member.getAttributeList().getAccessType();
                switch (accessType) {
                    case PRIVATE: {
                        if (!JSPullUpHelper.willBeUsedInSubclass((PsiElement)member, movedMembers, this.myTargetClass, this.mySourceClass)) break;
                        JSChangeVisibilityUtil.setVisibility(member, JSAttributeList.AccessType.PROTECTED);
                        break;
                    }
                    case PACKAGE_LOCAL: {
                        AtomicBoolean usedInPackage = new AtomicBoolean(false);
                        AtomicBoolean usedInSubClass = new AtomicBoolean(false);
                        ReferencesSearch.search((PsiElement)member, (SearchScope)GlobalSearchScope.moduleScope((Module)ModuleUtil.findModuleForPsiElement((PsiElement)member))).forEach(psiReference -> {
                            if (!(psiReference.getElement() instanceof JSReferenceExpression)) {
                                return true;
                            }
                            if (JSRefactoringUtil.isOrWillBeInTargetClass(psiReference.getElement(), movedMembers, this.myTargetClass, false)) {
                                return true;
                            }
                            JSClass clazz = JSResolveUtil.getClassOfContext(psiReference.getElement());
                            if (clazz == this.myTargetClass) {
                                return true;
                            }
                            if (clazz != null && JSInheritanceUtil.isParentClass(this.mySourceClass, clazz, false)) {
                                usedInSubClass.set(true);
                            } else {
                                usedInPackage.set(true);
                            }
                            return !usedInPackage.get() || !usedInSubClass.get();
                        });
                        if (usedInPackage.get() && usedInSubClass.get()) {
                            JSChangeVisibilityUtil.setVisibility(member, JSAttributeList.AccessType.PUBLIC);
                            break;
                        }
                        if (usedInPackage.get()) {
                            JSChangeVisibilityUtil.setVisibility(member, JSAttributeList.AccessType.PACKAGE_LOCAL);
                            break;
                        }
                        if (!usedInSubClass.get()) break;
                        JSChangeVisibilityUtil.setVisibility(member, JSAttributeList.AccessType.PROTECTED);
                        break;
                    }
                }
            }
            JSRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, movedMembers, this.myTargetClass, this.myTargetClass.isInterface() && !this.mySourceClass.isInterface(), false);
        }
        Object membersAfterMove = new com.intellij.util.containers.HashSet();
        for (JSMemberInfo info : this.myMembersToMove) {
            JSAttributeListOwner toDelete;
            JSElement newMember;
            JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
            if (member instanceof JSFunction) {
                JSFunction method = (JSFunction)member;
                if (this.myTargetClass.isInterface() && !this.mySourceClass.isInterface()) {
                    JSFunction abstractMethod = JSRefactoringUtil.buildAbstractMethod(method);
                    PsiElement docComment = JSRefactoringUtil.findDocComment((PsiElement)method);
                    newMember = (JSElement)this.myTargetClass.add((PsiElement)abstractMethod);
                    if (docComment != null) {
                        if (this.myDocCommentPolicy == 1) {
                            JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
                        } else if (this.myDocCommentPolicy == 0) {
                            docComment = JSRefactoringUtil.findDocComment((PsiElement)newMember);
                            JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
                        }
                    }
                    ArrayList<JSFunction> makePublic = new ArrayList<JSFunction>();
                    makePublic.add(method);
                    Processor p = function -> {
                        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)function) != null) {
                            makePublic.add((JSFunction)function);
                        }
                        return true;
                    };
                    JSInheritanceUtil.iterateOverriddenMethodsUp(method, (Processor<JSFunction>)p);
                    JSFunctionsSearch.searchOverridingFunctions(method, true).forEach(p);
                    for (JSFunction f : makePublic) {
                        JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)f, JSAttributeList.AccessType.PUBLIC);
                        postponedFormatters.add(FormatFixer.create((PsiElement)f, FormatFixer.Mode.Reformat));
                    }
                    toDelete = null;
                } else {
                    newMember = (JSElement)JSRefactoringUtil.addMemberToTargetClass(this.myTargetClass, member.copy());
                    toDelete = member;
                    JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)newMember, postponedFormatters);
                }
            } else if (member instanceof JSVariable) {
                PsiElement varStatementCopy = JSRefactoringUtil.addMemberToTargetClass(this.myTargetClass, (PsiElement)JSRefactoringUtil.getVarStatementCopy((JSVariable)member));
                newMember = (JSElement)PsiTreeUtil.getChildOfType((PsiElement)varStatementCopy, JSVariable.class);
                toDelete = member;
                JSRefactoringUtil.handleDocCommentAndFormat(varStatementCopy, postponedFormatters);
            } else {
                JSClass aClass = (JSClass)member;
                LOG.assertTrue(Boolean.FALSE.equals(info.getOverrides()));
                JSReferenceList refList = info.isExtendsNotImplements() ? this.mySourceClass.getExtendsList() : this.mySourceClass.getImplementsList();
                String refText = JSRefactoringUtil.removeFromReferenceList(refList, aClass, postponedFormatters);
                if (refText != null) {
                    JSRefactoringUtil.addToSupersList(this.myTargetClass, aClass.getQualifiedName(), true);
                }
                String qName = aClass.getQualifiedName();
                if (!(this.myTargetClass instanceof XmlBackedJSClass) && qName.indexOf(46) != -1 && JSPsiImplUtils.differentPackageName(qName, this.myTargetClass.getQualifiedName())) {
                    importsInTargetFile.add(qName);
                }
                newMember = null;
                toDelete = null;
            }
            if (toDelete != null) {
                JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)toDelete);
            }
            if (newMember == null) continue;
            membersAfterMove.add(newMember);
        }
        ExplicitSuperDeleter explicitSuperDeleter = new ExplicitSuperDeleter();
        Iterator info = membersAfterMove.iterator();
        while (info.hasNext()) {
            JSElement member = (JSElement)info.next();
            member.accept((PsiElementVisitor)explicitSuperDeleter);
        }
        explicitSuperDeleter.fixSupers();
        List<SmartPsiElementPointer<JSElement>> pointers = JSPullUpHelper.convertToPointers((Collection<JSElement>)membersAfterMove);
        JSRefactoringUtil.postProcess((PsiElement)this.mySourceClass, (JSQualifiedNamedElement)this.myTargetClass, filesWithUsages, importsInTargetFile, namespacesInTargetFile, postponedFormatters, allowFormat, false);
        membersAfterMove = JSPullUpHelper.convertToPsi(pointers);
        return membersAfterMove;
    }

    private static List<SmartPsiElementPointer<JSElement>> convertToPointers(Collection<JSElement> elements) {
        return ContainerUtil.map(elements, element -> SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer((PsiElement)element));
    }

    private static List<JSElement> convertToPsi(Collection<SmartPsiElementPointer<JSElement>> pointers) {
        return ContainerUtil.map(pointers, pointer -> (JSElement)pointer.getElement());
    }

    private static boolean willBeUsedInSubclass(PsiElement member, Collection<JSAttributeListOwner> movedMembers, JSClass superclass, JSClass subclass) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)subclass), (boolean)false)) {
            PsiElement element = ref.getElement();
            if (JSRefactoringUtil.isOrWillBeInTargetClass(element, movedMembers, superclass, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkedInterfacesContain(Collection<JSMemberInfo> memberInfos, JSFunction psiMethod) {
        for (MemberInfoBase memberInfoBase : memberInfos) {
            if (!memberInfoBase.isChecked() || !(memberInfoBase.getMember() instanceof JSClass)) continue;
            assert (Boolean.FALSE.equals(memberInfoBase.getOverrides()));
            if (((JSClass)memberInfoBase.getMember()).findFunctionByName(psiMethod.getName()) == null) continue;
            return true;
        }
        return false;
    }

    private static class ExplicitSuperDeleter
    extends JSRecursiveElementVisitor {
        private final ArrayList<JSExpression> mySupersToDelete = new ArrayList();
        private boolean myInsideObjectStatus;
        private boolean myInsideObjectStatusCalculated;

        private ExplicitSuperDeleter() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            PsiElement resolved;
            if (expression.getQualifier() instanceof JSSuperExpression && ((resolved = expression.resolve()) == null || this.myInsideObjectStatus)) {
                this.mySupersToDelete.add(expression.getQualifier());
            }
        }

        public void visitJSElement(JSElement node) {
            PsiElement parentNode;
            if (!this.myInsideObjectStatusCalculated && node instanceof JSNamedElement && (parentNode = JSResolveUtil.findParent((PsiElement)node)) instanceof JSClass) {
                JSClass[] superClasses = ((JSClass)parentNode).getSuperClasses();
                if (superClasses.length > 0 && "Object".equals(superClasses[0].getQualifiedName())) {
                    this.myInsideObjectStatus = true;
                }
                this.myInsideObjectStatusCalculated = true;
            }
            super.visitJSElement(node);
        }

        public void fixSupers() throws IncorrectOperationException {
            for (JSExpression expression : this.mySupersToDelete) {
                LOG.assertTrue(expression.getNextSibling() != null && expression.getNextSibling().getNode().getElementType() == JSTokenTypes.DOT);
                expression.getParent().deleteChildRange((PsiElement)expression, expression.getNextSibling());
            }
        }
    }
}

