/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSLanguageService {
    default public void openEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/JSLanguageService", "openEditor"));
        }
    }

    default public void closeLastEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/JSLanguageService", "closeLastEditor"));
        }
    }

    @Nullable
    public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile var1, @NotNull JSFileHighlightingInfo var2);

    public boolean canHighlight(@NotNull PsiFile var1);

    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter();

    default public boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/JSLanguageService", "isAcceptable"));
        }
        return this.getAcceptableFilesFilter().value((Object)file);
    }

    @NotNull
    default public Collection<? extends IntentionAction> getFixes(@NotNull PsiFile file, @NotNull JSAnnotationError result) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/JSLanguageService", "getFixes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/service/JSLanguageService", "getFixes"));
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageService", "getFixes"));
        }
        return list;
    }
}

