/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ImplementMethodsFix
extends BaseCreateMethodsFix<JSFunction>
implements IntentionAction {
    public ImplementMethodsFix(JSClass jsClass) {
        super(jsClass);
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.implement.methods", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ImplementMethodsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ImplementMethodsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ImplementMethodsFix", "isAvailable"));
        }
        return this.myJsClass.isValid();
    }

    @Override
    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSFunction function) {
        super.adjustAttributeList(attributeListWrapper, function);
        if (DialectDetector.isActionScript((PsiElement)this.myJsClass)) {
            attributeListWrapper.overrideAccessType(JSAttributeList.AccessType.PUBLIC);
        }
    }

    @Override
    protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSFunction func) {
        String s = "{\n";
        if (retType != null && !"void".equals(retType)) {
            s = s + "return " + JSTypeUtils.defaultValueOfType(retType) + JSCodeStyleSettings.getSemicolon(func.getContainingFile()) + "\n";
        }
        s = s + "}";
        return s;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

