/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceUtil {
    public static final String TYPESCRIPT_MODULE_NAME = "typescript";
    public static final String LIB_DIRECTORY = "lib";
    public static final Condition<VirtualFile> FILES_TO_PROCESS = virtualFile -> {
        if (virtualFile == null) {
            return false;
        }
        FileType type = virtualFile.getFileType();
        return TypeScriptCompilerSettings.acceptFileType(type) && virtualFile.isInLocalFileSystem() && virtualFile.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER) == null;
    };
    public static volatile boolean USE_SERVICE = false;

    public static void setUseService(boolean useService) {
        USE_SERVICE = useService;
    }

    public static boolean isServiceEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return TypeScriptLanguageServiceUtil.isServiceEnabled(settings);
    }

    public static boolean isServiceEnabled(@Nullable TypeScriptCompilerSettings settings) {
        if (settings == null || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        return settings.isUseService() || settings.isCompilerEnabledAndNeedTrackChanges();
    }

    public static boolean useServiceCompletion(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceCompletion"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceCompletion"));
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && TypeScriptCompilerSettings.getSettings(project).isUseServiceCompletion();
    }

    public static boolean useServiceParameterInfo(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceParameterInfo"));
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && FILES_TO_PROCESS.value((Object)file) && TypeScriptCompilerSettings.getSettings(project).isUseServiceParameterInfo();
    }

    @Contract(value="null -> false")
    public static boolean checkProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && project.isOpen();
    }

    private static boolean useNewTypeScriptService(@Nullable Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.isUseService();
    }

    @Nullable
    public static VirtualFile getMainFile(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getMainFile"));
        }
        if (TypeScriptLanguageServiceUtil.shouldUseMainFile(settings)) {
            String path = settings.getMainFilePath();
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static boolean shouldUseMainFile(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "shouldUseMainFile"));
        }
        return !settings.isUseConfigForCompiler() && settings.isCompilerEnabled() && settings.isUseMainFile();
    }

    @Nullable
    public static VirtualFile findTypeScriptLibDirectory(@Nullable Project project) {
        VirtualFile node_modules;
        VirtualFile lib;
        VirtualFile root;
        if (project == null || project.isDefault() || project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return null;
        }
        Object[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        if (stopDirs.length == 1 && (root = (VirtualFile)ArrayUtil.getFirstElement((Object[])stopDirs)) != null && (lib = TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModules(node_modules = root.findChild("node_modules"))) != null) {
            return lib;
        }
        return (VirtualFile)ReadAction.compute(() -> {
            Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(project);
            if (files.isEmpty()) {
                return null;
            }
            ArrayList result = ContainerUtil.newArrayList();
            for (TypeScriptConfig file : files) {
                VirtualFile directory = file.getConfigDirectory();
                VirtualFile configNodeModules = directory.findChild("node_modules");
                result.add(TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModules(configNodeModules));
            }
            if (result.size() == 1) {
                return (VirtualFile)ContainerUtil.getFirstItem((List)result);
            }
            return null;
        });
    }

    public static VirtualFile getTypeScriptLibFromNodeModules(@Nullable VirtualFile nodeModules) {
        if (nodeModules == null) {
            return null;
        }
        VirtualFile typescript = nodeModules.findChild(TYPESCRIPT_MODULE_NAME);
        if (typescript == null) {
            return null;
        }
        VirtualFile lib = typescript.findChild(LIB_DIRECTORY);
        if (lib == null) {
            return null;
        }
        VirtualFile[] children = lib.getChildren();
        if (children != null) {
            for (VirtualFile file : children) {
                if (!ArrayUtil.contains((String)file.getName(), (String[])TypeScriptCompilerSettings.TYPESCRIPT_SERVICE_FILES)) continue;
                return lib;
            }
        }
        return null;
    }

    @Nullable
    public static String getNormalizedVersionString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Version parseVersion = Version.parseVersion((String)version);
        if (parseVersion == null) {
            return null;
        }
        return parseVersion.toString();
    }

    public static void fillFilePosition(@NotNull TypeScriptFileLocationRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull Document document, int positionInFileOffset) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "fillFilePosition"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "fillFilePosition"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "fillFilePosition"));
        }
        if (document instanceof DocumentWindow) {
            positionInFileOffset = ((DocumentWindow)document).injectedToHost(positionInFileOffset);
            document = ((DocumentWindow)document).getDelegate();
        }
        int line = document.getLineNumber(positionInFileOffset);
        int offset = positionInFileOffset - document.getLineStartOffset(line);
        args.line = line + 1;
        args.offset = offset + 1;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile);
    }

    @Nullable
    public static String getNodeInterpreterPath(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        String interpreter = settings.getNodeInterpreter();
        if (interpreter == null) {
            return JSLanguageServiceUtil.getInterpreterPathIfValid(NodeJsInterpreterManager.getInstance(project).getDefault());
        }
        NodeJsInterpreterRef refName = NodeJsInterpreterRef.create(interpreter);
        return JSLanguageServiceUtil.getInterpreterPathIfValid(refName.resolve(project));
    }

    @Contract(value="!null,_->!null")
    public static String getRelativePath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getRelativePath"));
        }
        if (StringUtil.isEmpty((String)path)) {
            return path;
        }
        return (String)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "lambda$getRelativePath$2"));
            }
            VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
            if (fileByPath == null) {
                return path;
            }
            if (DumbService.isDumb((Project)project) || project.isDisposed() || !project.isOpen()) {
                return path;
            }
            VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(fileByPath);
            if (root != null) {
                return "/" + VfsUtilCore.getRelativePath((VirtualFile)fileByPath, (VirtualFile)root);
            }
            return path;
        });
    }

    @Nullable
    public static JSLanguageServiceUtil.PsiElementInfo getPsiElementInfo(@Nullable PsiFile file, @NotNull Document document, @Nullable TypeScriptResponseCommon.Location start, @Nullable TypeScriptResponseCommon.Location end) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getPsiElementInfo"));
        }
        if (start == null || end == null) {
            return null;
        }
        int line = start.line - 1;
        int startOffset = start.offset - 1;
        int endLine = end.line - 1;
        int endOffset = end.offset - 1;
        return JSLanguageServiceUtil.getElementInfo(file, document, line, startOffset, endLine, endOffset);
    }
}

