/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dom;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformDetectionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("platform.detection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dom/PlatformDetectionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.DOM_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dom/PlatformDetectionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("platform.detection.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression referenceExpression) {
            super.visitJSReferenceExpression(referenceExpression);
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            if ("navigator".equalsIgnoreCase(qualifierText)) {
                String methodName = referenceExpression.getReferencedName();
                if (!("userAgent".equalsIgnoreCase(methodName) || "appName".equalsIgnoreCase(methodName) || "appCodeName".equalsIgnoreCase(methodName) || "platform".equalsIgnoreCase(methodName) || "oscpu".equalsIgnoreCase(methodName))) {
                    return;
                }
                this.registerError((PsiElement)referenceExpression);
            } else if ("document".equalsIgnoreCase(qualifierText)) {
                String methodName = referenceExpression.getReferencedName();
                if (!"all".equalsIgnoreCase(methodName) && !"layers".equalsIgnoreCase(methodName)) {
                    return;
                }
                this.registerError((PsiElement)referenceExpression);
            }
        }
    }
}

