/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.exception.CatchParameterUsedVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnusedCatchParameterJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreCatchBlocksWithComments = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unused.catch.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/UnusedCatchParameterJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ERRORHANDLING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/UnusedCatchParameterJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("unused.catch.parameter.ignore.catch.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreCatchBlocksWithComments");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unused.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/UnusedCatchParameterJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyCatchBlockVisitor();
    }

    private class EmptyCatchBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyCatchBlockVisitor() {
        }

        public void visitJSTryStatement(@NotNull JSTryStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/exception/UnusedCatchParameterJSInspection$EmptyCatchBlockVisitor", "visitJSTryStatement"));
            }
            super.visitJSTryStatement(statement);
            JSCatchBlock jsCatchBlock = statement.getCatchBlock();
            if (jsCatchBlock == null) {
                return;
            }
            this.checkCatchSection(jsCatchBlock);
        }

        private void checkCatchSection(JSCatchBlock section) {
            JSParameter param = section.getParameter();
            JSStatement block = section.getStatement();
            if (param == null || block == null) {
                return;
            }
            String paramName = param.getName();
            if ("ignore".equals(paramName) || "ignored".equals(paramName)) {
                return;
            }
            if (UnusedCatchParameterJSInspection.this.m_ignoreCatchBlocksWithComments) {
                PsiElement[] children;
                for (PsiElement child : children = block.getChildren()) {
                    if (!(child instanceof PsiComment)) continue;
                    return;
                }
            }
            CatchParameterUsedVisitor visitor = new CatchParameterUsedVisitor(param);
            block.accept((PsiElementVisitor)visitor);
            if (!visitor.isUsed()) {
                this.registerVariableError((JSVariable)param);
            }
        }
    }
}

