/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gant.AntBuilderMethod;
import org.jetbrains.plugins.groovy.gant.AntTasksProvider;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GantMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiFile file;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/gant/GantMemberContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/gant/GantMemberContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/gant/GantMemberContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/gant/GantMemberContributor", "processDynamicElements"));
        }
        if (aClass != null && ClassUtil.getSuperClassesWithCache(aClass).containsKey("groovy.util.AntBuilder")) {
            GantMemberContributor.processAntTasks(processor, place, state);
            return;
        }
        if (!(place instanceof GrReferenceExpression) || ((GrReferenceExpression)place).isQualified()) {
            return;
        }
        GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getContextOfType((PsiElement)place, GrClosableBlock.class, (boolean)true);
        boolean antTasksProcessed = false;
        while (closure != null) {
            PsiMethod method;
            PsiElement parent = closure.getParent();
            if (parent instanceof GrMethodCall && (method = ((GrMethodCall)parent).resolveMethod()) instanceof AntBuilderMethod) {
                antTasksProcessed = true;
                if (!GantMemberContributor.processAntTasks(processor, place, state)) {
                    return;
                }
                if (((AntBuilderMethod)method).processNestedElements(processor)) break;
                return;
            }
            closure = (GrClosableBlock)PsiTreeUtil.getContextOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true);
        }
        if ((file = place.getContainingFile()) == null || !GroovyScriptUtil.isSpecificScriptFile(file, GantScriptType.INSTANCE)) {
            return;
        }
        if (aClass instanceof GroovyScriptClass) {
            for (GrArgumentLabel label : GantUtils.getScriptTargets((GroovyFile)file)) {
                LightVariableBuilder variable;
                String targetName = label.getName();
                if (targetName == null || ResolveUtil.processElement(processor, (PsiNamedElement)(variable = new LightVariableBuilder(targetName, "groovy.lang.Closure", (PsiElement)label).setBaseIcon(JetgroovyIcons.Groovy.Gant_target)), state)) continue;
                return;
            }
        }
        if (!antTasksProcessed) {
            GantMemberContributor.processAntTasks(processor, place, state);
        }
    }

    private static boolean processAntTasks(PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        for (LightMethodBuilder task : AntTasksProvider.getAntTasks(place)) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)task, state)) continue;
            return false;
        }
        return true;
    }
}

