/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class GroovySdkWizardStepBase
extends ModuleWizardStep {
    private final String myBasePath;
    private LibraryOptionsPanel myPanel;
    private final LibrariesContainer myLibrariesContainer;
    private boolean myDownloaded;
    private LibraryCompositionSettings myLibraryCompositionSettings;
    @Nullable
    private final MvcFramework myFramework;
    private final Disposable myDisposable;

    public GroovySdkWizardStepBase(@Nullable MvcFramework framework, WizardContext wizardContext, String basePath) {
        this.myBasePath = basePath;
        this.myLibrariesContainer = wizardContext.getModulesProvider() == null ? LibrariesContainerFactory.createContainer((Project)wizardContext.getProject()) : LibrariesContainerFactory.createContainer((WizardContext)wizardContext, (ModulesProvider)wizardContext.getModulesProvider());
        this.myFramework = framework;
        this.myDisposable = wizardContext.getDisposable();
    }

    protected ModuleBuilder.ModuleConfigurationUpdater createModuleConfigurationUpdater() {
        return new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/GroovySdkWizardStepBase$1", "update"));
                }
                if (rootModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/plugins/groovy/mvc/GroovySdkWizardStepBase$1", "update"));
                }
                if (GroovySdkWizardStepBase.this.myLibraryCompositionSettings != null) {
                    GroovySdkWizardStepBase.this.myLibraryCompositionSettings.addLibraries(rootModel, new ArrayList(), GroovySdkWizardStepBase.this.myLibrariesContainer);
                }
                module.putUserData(MvcFramework.CREATE_APP_STRUCTURE, (Object)Boolean.TRUE);
            }
        };
    }

    public JComponent getComponent() {
        return this.getPanel().getMainPanel();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch." + (this.myFramework == null ? "groovy" : this.myFramework.getFrameworkName().toLowerCase());
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        if (finishChosen && !this.myDownloaded && this.myLibraryCompositionSettings != null && this.myLibraryCompositionSettings.downloadFiles(this.getPanel().getMainPanel())) {
            this.myDownloaded = true;
        }
    }

    public void updateDataModel() {
        this.myLibraryCompositionSettings = this.getPanel().apply();
    }

    protected LibraryOptionsPanel getPanel() {
        if (this.myPanel == null) {
            GroovyLibraryDescription libraryDescription = this.myFramework == null ? new GroovyLibraryDescription() : this.myFramework.createLibraryDescription();
            String baseDirPath = this.myBasePath != null ? FileUtil.toSystemIndependentName((String)this.myBasePath) : "";
            this.myPanel = new LibraryOptionsPanel((CustomLibraryDescription)libraryDescription, baseDirPath, FrameworkLibraryVersionFilter.ALL, this.myLibrariesContainer, false);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPanel);
        }
        return this.myPanel;
    }
}

