/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestMethods
extends TestMethod {
    private static final Logger LOG = Logger.getInstance(TestMethods.class);
    private final Collection<AbstractTestProxy> myFailedTests;

    public TestMethods(@NotNull JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull Collection<AbstractTestProxy> failedTests) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/junit/TestMethods", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/junit/TestMethods", "<init>"));
        }
        if (failedTests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedTests", "com/intellij/execution/junit/TestMethods", "<init>"));
        }
        super(configuration, environment);
        this.myFailedTests = failedTests;
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createDefaultJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        RunConfigurationModule configurationModule = this.getConfiguration().getConfigurationModule();
        Project project = configurationModule.getProject();
        Module module = configurationModule.getModule();
        GlobalSearchScope searchScope = module != null ? module.getModuleRuntimeScope(true) : GlobalSearchScope.allScope((Project)project);
        this.addClassesListToJavaParameters(this.myFailedTests, testInfo -> testInfo != null ? TestMethods.getTestPresentation(testInfo, project, searchScope) : null, data.getPackageName(), true, javaParameters);
        return javaParameters;
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
    }

    protected boolean configureByModule(Module module) {
        return super.configureByModule(module) && this.getConfiguration().getPersistentData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    @Nullable
    public static String getTestPresentation(AbstractTestProxy testInfo, Project project, GlobalSearchScope searchScope) {
        PsiElement element;
        Location location = testInfo.getLocation(project, searchScope);
        PsiElement psiElement = element = location != null ? location.getPsiElement() : null;
        if (element instanceof PsiMethod) {
            PsiClass containingClass;
            PsiClass psiClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (containingClass = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMethod)element).getContainingClass());
            if (containingClass != null) {
                String proxyName = testInfo.getName();
                String methodName = ((PsiMethod)element).getName();
                return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)containingClass) + "," + (proxyName.contains(methodName) ? proxyName.substring(proxyName.indexOf(methodName)) : methodName);
            }
        }
        return null;
    }

    @Override
    public String suggestActionName() {
        return ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]);
    }
}

