/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class WrongImportDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("SuspiciousImport", "'`import android.R`' statement", "Importing `android.R` is usually not intentional; it sometimes happens when you use an IDE and ask it to automatically add imports at a time when your project's R class it not present.\n\nOnce the import is there you might get a lot of \"confusing\" error messages because of course the fields available on `android.R` are not the ones you'd expect from just looking at your own `R` class.", Category.CORRECTNESS, 9, Severity.WARNING, new Implementation(WrongImportDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UImportStatement.class);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new ImportVisitor(context);
    }

    private static class ImportVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        private ImportVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitImportStatement(UImportStatement statement) {
            String qualifiedName;
            PsiElement resolved = statement.resolve();
            if (resolved instanceof PsiClass && "android.R".equals(qualifiedName = ((PsiClass)resolved).getQualifiedName())) {
                Location location = this.mContext.getUastLocation((UElement)statement);
                this.mContext.report(ISSUE, (UElement)statement, location, "Don't include `android.R` here; use a fully qualified name for each usage instead");
            }
            return super.visitImportStatement(statement);
        }
    }
}

