/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.klint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.klint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.klint.ApiUtilsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010\u0012\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u0005*\u00020\u000eH\u0002J\f\u0010\u001d\u001a\u00020\u0005*\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/android/inspections/klint/AddTargetApiQuickFix;", "Lorg/jetbrains/android/inspections/klint/AndroidLintQuickFix;", "api", "", "useRequiresApi", "", "(IZ)V", "getApi", "()I", "getUseRequiresApi", "()Z", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lorg/jetbrains/android/inspections/klint/AndroidQuickfixContexts$Context;", "getAnnotationContainer", "Lorg/jetbrains/annotations/Nullable;", "element", "getAnnotationValue", "", "fullyQualified", "getName", "isApplicable", "contextType", "Lorg/jetbrains/android/inspections/klint/AndroidQuickfixContexts$ContextType;", "isRequiresApiAnnotationValidTarget", "isTargetApiAnnotationValidTarget", "Companion", "lint-idea"})
public final class AddTargetApiQuickFix
implements AndroidLintQuickFix {
    private final int api;
    private final boolean useRequiresApi;
    @NotNull
    private static final FqName FQNAME_TARGET_API;
    @NotNull
    private static final FqName FQNAME_REQUIRES_API;
    public static final Companion Companion;

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)contextType, (String)"contextType");
        return this.getAnnotationContainer(startElement, this.useRequiresApi) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        String string2;
        String it = string2 = this.getAnnotationValue(false);
        if (this.useRequiresApi) {
            string = "Add @RequiresApi(" + it + ") Annotation";
        } else {
            String string3 = AndroidBundle.message((String)"android.lint.fix.add.target.api", (Object[])new Object[]{it});
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"AndroidBundle.message(\"a\u2026.fix.add.target.api\", it)");
        }
        return string;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement = this.getAnnotationContainer(startElement, this.useRequiresApi);
        if (psiElement == null) {
            return;
        }
        PsiElement annotationContainer2 = psiElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(annotationContainer2)) {
            return;
        }
        if (annotationContainer2 instanceof KtModifierListOwner) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)annotationContainer2), (FqName)(this.useRequiresApi ? Companion.getFQNAME_REQUIRES_API() : Companion.getFQNAME_TARGET_API()), (String)this.getAnnotationValue(true), (String)"\n", null, (int)8, null);
        }
    }

    private final String getAnnotationValue(boolean fullyQualified) {
        return ApiUtilsKt.getVersionField(this.api, fullyQualified);
    }

    private final PsiElement getAnnotationContainer(PsiElement element, boolean useRequiresApi) {
        return PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)((Condition)new Condition<PsiElement>(this, useRequiresApi){
            final /* synthetic */ AddTargetApiQuickFix this$0;
            final /* synthetic */ boolean $useRequiresApi;

            public final boolean value(PsiElement it) {
                return this.$useRequiresApi ? AddTargetApiQuickFix.access$isRequiresApiAnnotationValidTarget(this.this$0, it) : AddTargetApiQuickFix.access$isTargetApiAnnotationValidTarget(this.this$0, it);
            }
            {
                this.this$0 = addTargetApiQuickFix;
                this.$useRequiresApi = bl;
            }
        }));
    }

    private final boolean isRequiresApiAnnotationValidTarget(@NotNull PsiElement $receiver) {
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtFunction && !($receiver instanceof KtFunctionLiteral) || $receiver instanceof KtProperty && !((KtProperty)$receiver).isLocal();
    }

    private final boolean isTargetApiAnnotationValidTarget(@NotNull PsiElement $receiver) {
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtFunction && !($receiver instanceof KtFunctionLiteral);
    }

    public final int getApi() {
        return this.api;
    }

    public final boolean getUseRequiresApi() {
        return this.useRequiresApi;
    }

    public AddTargetApiQuickFix(int api, boolean useRequiresApi) {
        this.api = api;
        this.useRequiresApi = useRequiresApi;
    }

    static {
        Companion = new Companion(null);
        FQNAME_TARGET_API = new FqName("android.annotation.TargetApi");
        FQNAME_REQUIRES_API = new FqName("android.support.annotation.RequiresApi");
    }

    public static final /* synthetic */ boolean access$isRequiresApiAnnotationValidTarget(AddTargetApiQuickFix $this, @NotNull PsiElement $receiver) {
        return $this.isRequiresApiAnnotationValidTarget($receiver);
    }

    public static final /* synthetic */ boolean access$isTargetApiAnnotationValidTarget(AddTargetApiQuickFix $this, @NotNull PsiElement $receiver) {
        return $this.isTargetApiAnnotationValidTarget($receiver);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/android/inspections/klint/AddTargetApiQuickFix$Companion;", "", "()V", "FQNAME_REQUIRES_API", "Lorg/jetbrains/kotlin/name/FqName;", "getFQNAME_REQUIRES_API", "()Lorg/jetbrains/kotlin/name/FqName;", "FQNAME_TARGET_API", "getFQNAME_TARGET_API", "lint-idea"})
    private static final class Companion {
        @NotNull
        public final FqName getFQNAME_TARGET_API() {
            return FQNAME_TARGET_API;
        }

        @NotNull
        public final FqName getFQNAME_REQUIRES_API() {
            return FQNAME_REQUIRES_API;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

