/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("ManifestResource", "Manifest Resource References", "Elements in the manifest can reference resources, but those resources cannot vary across configurations (except as a special case, by version, and except for a few specific package attributes such as the application title and icon.)", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(ManifestResourceDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, Scope.MANIFEST_SCOPE));
    private Map<String, Multimap<ResourceType, Location>> mManifestLocations;

    @Override
    public void visitDocument(XmlContext context, Document document) {
        if (SdkUtils.endsWithIgnoreCase((String)context.file.getPath(), (String)"AndroidManifest.xml")) {
            this.checkManifest(context, document);
        } else if (this.mManifestLocations != null) {
            this.checkResourceFile(context, document);
        }
    }

    private void checkManifest(XmlContext context, Document document) {
        LintClient client = context.getClient();
        Project project = context.getProject();
        AbstractResourceRepository repository = null;
        if (client.supportsProjectResources()) {
            repository = client.getResourceRepository(project, true, false);
        }
        if (repository == null && !context.getScope().contains((Object)Scope.RESOURCE_FILE)) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root != null) {
            this.visit(context, root, repository);
        }
    }

    private void visit(XmlContext context, Element element, AbstractResourceRepository repository) {
        if ("meta-data".equals(element.getTagName())) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attribute;
            Node node = attributes.item(i);
            String value = node.getNodeValue();
            if (!value.startsWith("@") || ManifestResourceDetector.isAllowedToVary(attribute = (Attr)node)) continue;
            this.checkReference(context, attribute, value, repository);
        }
        NodeList children = element.getChildNodes();
        int n2 = children.getLength();
        for (int i = 0; i < n2; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.visit(context, (Element)child, repository);
        }
    }

    private static boolean isAllowedToVary(Attr attribute) {
        String name = attribute.getLocalName();
        if ("label".equals(name) || "icon".equals(name) || "theme".equals(name) || "description".equals(name) || "logo".equals(name) || "banner".equals(name) || "sharedUserLabel".equals(name)) {
            return "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI());
        }
        return false;
    }

    private void checkReference(XmlContext context, Attr attribute, String value, AbstractResourceRepository repository) {
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (url != null && !url.framework) {
            if (repository != null) {
                List items = repository.getResourceItem(url.type, url.name);
                if (items != null && items.size() > 1) {
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)5);
                    for (ResourceItem item : items) {
                        String qualifiers = item.getQualifiers();
                        if (qualifiers.isEmpty() || VersionQualifier.getQualifier((String)qualifiers) != null) continue;
                        list.add(qualifiers);
                    }
                    if (!list.isEmpty()) {
                        Collections.sort(list);
                        String message = ManifestResourceDetector.getErrorMessage(Joiner.on((String)", ").join((Iterable)list));
                        context.report(ISSUE, attribute, context.getValueLocation(attribute), message);
                    }
                }
            } else if (!context.getDriver().isSuppressed(context, ISSUE, attribute)) {
                ArrayListMultimap typeMap;
                if (this.mManifestLocations == null) {
                    this.mManifestLocations = Maps.newHashMap();
                }
                if ((typeMap = this.mManifestLocations.get(url.name)) == null) {
                    typeMap = ArrayListMultimap.create();
                    this.mManifestLocations.put(url.name, (Multimap<ResourceType, Location>)typeMap);
                }
                typeMap.put((Object)url.type, (Object)context.getValueLocation(attribute));
            }
        }
    }

    private void checkResourceFile(XmlContext context, Document document) {
        block8: {
            String name;
            ResourceFolderType folderType;
            String qualifiers;
            block7: {
                File parentFile = context.file.getParentFile();
                if (parentFile == null) {
                    return;
                }
                String parentName = parentFile.getName();
                int index = parentName.indexOf(45);
                if (index == -1) {
                    return;
                }
                qualifiers = parentName.substring(index + 1);
                if (VersionQualifier.getQualifier((String)qualifiers) != null) {
                    return;
                }
                folderType = context.getResourceFolderType();
                if (folderType != ResourceFolderType.VALUES) break block7;
                Element root = document.getDocumentElement();
                if (root == null) break block8;
                NodeList children = root.getChildNodes();
                int n = children.getLength();
                for (int i = 0; i < n; ++i) {
                    ResourceType type;
                    String tag;
                    Element item;
                    String name2;
                    Node child = children.item(i);
                    if (child.getNodeType() != 1 || (name2 = (item = (Element)child).getAttribute("name")) == null || !this.mManifestLocations.containsKey(name2)) continue;
                    String typeString = tag = item.getTagName();
                    if (tag.equals("item")) {
                        typeString = item.getAttribute("type");
                    }
                    if ((type = ResourceType.getEnum((String)typeString)) == null) continue;
                    this.reportIfFound(context, qualifiers, name2, type, item);
                }
                break block8;
            }
            if (folderType != null && this.mManifestLocations.containsKey(name = LintUtils.getBaseName(context.file.getName()))) {
                List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : types) {
                    this.reportIfFound(context, qualifiers, name, type, document.getDocumentElement());
                }
            }
        }
    }

    private void reportIfFound(XmlContext context, String qualifiers, String name, ResourceType type, Node secondary) {
        Collection locations;
        Multimap<ResourceType, Location> typeMap = this.mManifestLocations.get(name);
        if (typeMap != null && (locations = typeMap.get((Object)type)) != null) {
            for (Location location : locations) {
                String message = ManifestResourceDetector.getErrorMessage(qualifiers);
                if (secondary != null) {
                    Location secondaryLocation = context.getLocation(secondary);
                    secondaryLocation.setSecondary(location.getSecondary());
                    secondaryLocation.setMessage("This value will not be used");
                    location.setSecondary(secondaryLocation);
                }
                context.report(ISSUE, location, message);
            }
        }
    }

    private static String getErrorMessage(String qualifiers) {
        return "Resources referenced from the manifest cannot vary by configuration (except for version qualifiers, e.g. `-v21`.) Found variation in " + qualifiers;
    }
}

