/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunnerParametersPanel;

public class MavenRunnerParametersSettingEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenRunnerParametersPanel myPanel;

    public MavenRunnerParametersSettingEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/execution/MavenRunnerParametersSettingEditor", "<init>"));
        }
        this.myPanel = new MavenRunnerParametersPanel(project);
    }

    protected void resetEditorFrom(@NotNull MavenRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/jetbrains/idea/maven/execution/MavenRunnerParametersSettingEditor", "resetEditorFrom"));
        }
        this.myPanel.getData(runConfiguration.getRunnerParameters());
    }

    protected void applyEditorTo(@NotNull MavenRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/jetbrains/idea/maven/execution/MavenRunnerParametersSettingEditor", "applyEditorTo"));
        }
        this.myPanel.setData(runConfiguration.getRunnerParameters());
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = this.myPanel.createComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerParametersSettingEditor", "createEditor"));
        }
        return jComponent;
    }

    protected void disposeEditor() {
        this.myPanel.disposeUIResources();
    }
}

