/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.maven.model.RepositoryLibraryDescriptor;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties> {
    private RepositoryLibraryDescriptor myDescriptor;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(String mavenId) {
        this.myDescriptor = new RepositoryLibraryDescriptor(mavenId);
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        this.myDescriptor = new RepositoryLibraryDescriptor(groupId, artifactId, version);
    }

    public boolean equals(Object obj) {
        return obj instanceof RepositoryLibraryProperties && Comparing.equal((Object)this.myDescriptor, (Object)((RepositoryLibraryProperties)((Object)obj)).myDescriptor);
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.getMavenId());
    }

    public RepositoryLibraryProperties getState() {
        return this;
    }

    public void loadState(RepositoryLibraryProperties state) {
        this.myDescriptor = state.myDescriptor;
    }

    @Attribute(value="maven-id")
    public String getMavenId() {
        return this.call(RepositoryLibraryDescriptor::getMavenId);
    }

    public void setMavenId(String mavenId) {
        this.myDescriptor = new RepositoryLibraryDescriptor(mavenId);
    }

    public String getGroupId() {
        return this.call(RepositoryLibraryDescriptor::getGroupId);
    }

    public String getArtifactId() {
        return this.call(RepositoryLibraryDescriptor::getArtifactId);
    }

    public String getVersion() {
        return this.call(RepositoryLibraryDescriptor::getVersion);
    }

    public void changeVersion(String version) {
        this.myDescriptor = new RepositoryLibraryDescriptor(this.getGroupId(), this.getArtifactId(), version);
    }

    private String call(Function<RepositoryLibraryDescriptor, String> method) {
        RepositoryLibraryDescriptor descriptor = this.myDescriptor;
        return descriptor != null ? method.apply(descriptor) : null;
    }
}

