/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.converters.jam;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.JavaeeAnnoNameReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SeamContextVariableReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object value;
        Module module;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/seam/converters/jam/SeamContextVariableReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/seam/converters/jam/SeamContextVariableReferenceProvider", "getReferencesByElement"));
        }
        PsiElement psiElement = CompletionUtil.getOriginalElement((PsiElement)element);
        if (psiElement != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement)) != null && (value = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getConstantEvaluationHelper().computeConstantExpression(psiElement)) instanceof String) {
            List<CommonModelElement> components = SeamCommonUtils.findSeamComponents((String)value, module);
            CommonModelElement resolveTo = components.size() > 0 ? components.get(0) : null;
            PsiReference[] psiReferenceArray = new PsiReference[]{new JavaeeAnnoNameReference(element, resolveTo){

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = SeamCommonUtils.getSeamContextVariableNames(module).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/converters/jam/SeamContextVariableReferenceProvider$1", "getVariants"));
                    }
                    return objectArray;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/converters/jam/SeamContextVariableReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/converters/jam/SeamContextVariableReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

