/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.dependencies;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.util.ArrayUtil;
import icons.SeamIcons;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamDependenciesVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    @NonNls
    static final String PROTOCOL = "SEAM_DEPENDENCIES";
    @NonNls
    static final String FILE_GRAPH = "SEAM_DEPENDENCIES_GRAPH";

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem", "findFileByPath"));
        }
        return new MyVirtualFile(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    private class MyVirtualFile
    extends VirtualFile {
        private final String myName;

        public MyVirtualFile(String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem$MyVirtualFile", "getName"));
            }
            return string;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            SeamDependenciesVirtualFileSystem seamDependenciesVirtualFileSystem = SeamDependenciesVirtualFileSystem.this;
            if (seamDependenciesVirtualFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem$MyVirtualFile", "getFileSystem"));
            }
            return seamDependenciesVirtualFileSystem;
        }

        @NotNull
        public String getPath() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem$MyVirtualFile", "getPath"));
            }
            return string;
        }

        public boolean isWritable() {
            return false;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public VirtualFile getParent() {
            return null;
        }

        public VirtualFile[] getChildren() {
            return VirtualFile.EMPTY_ARRAY;
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
            throw new UnsupportedOperationException("getOutputStream is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        @NotNull
        public byte[] contentsToByteArray() throws IOException {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesVirtualFileSystem$MyVirtualFile", "contentsToByteArray"));
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }

        public long getTimeStamp() {
            return 0L;
        }

        public long getLength() {
            return 0L;
        }

        public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("getInputStream is not implemented in : " + ((Object)((Object)this)).getClass());
        }

        public long getModificationStamp() {
            return 0L;
        }

        public Icon getIcon() {
            return SeamIcons.Seam;
        }

        public String getPresentableName() {
            return SeamBundle.message("seam.dependencies.file.name", this.getName());
        }
    }
}

