/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.impl.model.xml.SeamDomModelImpl;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.seam.utils.SeamConfigFileUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamDomModelFactory
extends DomModelFactory<SeamComponents, SeamDomModel, PsiElement> {
    public SeamDomModelFactory(Project project) {
        super(SeamComponents.class, project, "Seam");
    }

    @NotNull
    public Object[] computeDependencies(@Nullable SeamDomModel model, @Nullable Module module) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        if (module != null) {
            dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/xml/SeamDomModelFactory", "computeDependencies"));
        }
        return objectArray;
    }

    protected List<SeamDomModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/model/xml/SeamDomModelFactory", "computeAllModels"));
        }
        ArrayList<SeamDomModel> models = new ArrayList<SeamDomModel>();
        for (XmlFile xmlFile : SeamConfigFileUtils.getConfigurationFiles(module)) {
            SeamDomModel seamModel = this.createSingleModel(xmlFile, module);
            if (seamModel == null) continue;
            models.add(seamModel);
        }
        return models;
    }

    protected SeamDomModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/seam/model/xml/SeamDomModelFactory", "computeModel"));
        }
        if (module == null) {
            return null;
        }
        SeamDomModel model = (SeamDomModel)super.computeModel(psiFile, (UserDataHolder)module);
        return model != null ? model : this.createSingleModel(psiFile, module);
    }

    @Nullable
    private SeamDomModel createSingleModel(XmlFile psiFile, Module module) {
        DomFileElement componentsDomFileElement = this.getDomRoot(psiFile);
        if (componentsDomFileElement != null) {
            HashSet<XmlFile> files = new HashSet<XmlFile>();
            files.add(psiFile);
            SeamDomModelFactory.addImports(files, (SeamComponents)componentsDomFileElement.getRootElement());
            DomFileElement fileElement = files.size() > 1 ? this.createMergedModelRoot(files) : componentsDomFileElement;
            return fileElement == null ? null : new SeamDomModelImpl(module, (DomFileElement<SeamComponents>)fileElement, files);
        }
        return null;
    }

    protected SeamDomModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<SeamComponents> mergedModel, SeamDomModel firstModel, Module module) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/seam/model/xml/SeamDomModelFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/seam/model/xml/SeamDomModelFactory", "createCombinedModel"));
        }
        return new SeamDomModelImpl(module, mergedModel, configFiles);
    }

    private static void addImports(Set<XmlFile> files, SeamComponents components) {
        for (GenericDomValue genericDomValue : components.getImports()) {
        }
    }
}

