/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.providers;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class SeamComponentCompletionContributor
extends CompletionContributor {
    PsiJavaElementPattern componentNamePattern = PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.jboss.seam.annotations.Name"}));

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/seam/providers/SeamComponentCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/providers/SeamComponentCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/providers/SeamComponentCompletionContributor", "lambda$fillCompletionVariants$0"));
            }
            if (this.componentNamePattern.accepts((Object)position)) {
                result.stopHere();
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class);
                if (psiClass != null) {
                    Project project = psiClass.getProject();
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                    SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(psiClass));
                    for (String name : info.names) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                    }
                }
            }
        });
    }
}

