/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.Case;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Casing {
    public final Case plain;
    public final Case quoted;
    public static final Casing EXACT = Casing.create(Case.EXACT, Case.EXACT);

    @NotNull
    public static Casing create(@NotNull Case plain, @NotNull Case quoted) {
        if (plain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plain", "com/intellij/database/util/Casing", "create"));
        }
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "com/intellij/database/util/Casing", "create"));
        }
        Casing casing = new Casing(plain, quoted);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "create"));
        }
        return casing;
    }

    private Casing(@NotNull Case plain, @NotNull Case quoted) {
        if (plain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plain", "com/intellij/database/util/Casing", "<init>"));
        }
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "com/intellij/database/util/Casing", "<init>"));
        }
        this.plain = plain;
        this.quoted = quoted;
    }

    @NotNull
    public Case choose(boolean isPlain) {
        Case case_ = isPlain ? this.plain : this.quoted;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "choose"));
        }
        return case_;
    }

    @NotNull
    public String specification() {
        if (this.quoted == Case.EXACT) {
            String string = Casing.caseToString(this.plain);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "specification"));
            }
            return string;
        }
        String string = Casing.caseToString(this.plain) + '/' + Casing.caseToString(this.quoted);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "specification"));
        }
        return string;
    }

    @NotNull
    public static Casing of(@Nullable String str) {
        if (str == null) {
            Casing casing = EXACT;
            if (casing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "of"));
            }
            return casing;
        }
        String[] items = str.split("/");
        int n = items.length;
        Case c1 = n >= 1 ? Casing.caseFromString(items[0]) : Case.EXACT;
        Case c2 = n >= 2 ? Casing.caseFromString(items[1]) : Case.EXACT;
        Casing casing = Casing.create(c1, c2);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "of"));
        }
        return casing;
    }

    @NotNull
    private static String caseToString(@NotNull Case caze) {
        if (caze == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caze", "com/intellij/database/util/Casing", "caseToString"));
        }
        String string = caze.name().toLowerCase(Locale.ROOT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "caseToString"));
        }
        return string;
    }

    @NotNull
    private static Case caseFromString(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/util/Casing", "caseFromString"));
        }
        char c = str.length() >= 1 ? Character.toLowerCase(str.charAt(0)) : (char)'\u0000';
        switch (c) {
            case 'm': {
                Case case_ = Case.MIXED;
                if (case_ == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "caseFromString"));
                }
                return case_;
            }
            case 'u': {
                Case case_ = Case.UPPER;
                if (case_ == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "caseFromString"));
                }
                return case_;
            }
            case 'l': {
                Case case_ = Case.LOWER;
                if (case_ == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "caseFromString"));
                }
                return case_;
            }
        }
        Case case_ = Case.EXACT;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/Casing", "caseFromString"));
        }
        return case_;
    }

    public String toString() {
        return this.specification();
    }
}

