/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.PrimitiveStack;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;

public class IntegerStack
implements PrimitiveStack {
    private int position = 0;
    private int[] buffer;
    private int growSize;

    public IntegerStack(int n, int n2) {
        this.growSize = n2;
        this.buffer = new int[n];
    }

    @Override
    public final int capacity() {
        return this.buffer.length;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final void position(int n) throws IndexOutOfBoundsException {
        if (0 > this.position || this.position >= this.buffer.length) {
            String string = this.toString();
            throw new IndexOutOfBoundsException(new StringBuilder(34 + String.valueOf(string).length()).append("Invalid new position ").append(n).append(", ").append(string).toString());
        }
        this.position = n;
    }

    @Override
    public final int remaining() {
        return this.buffer.length - this.position;
    }

    @Override
    public final int getGrowSize() {
        return this.growSize;
    }

    @Override
    public final void setGrowSize(int n) {
        this.growSize = n;
    }

    public final String toString() {
        int n = this.position;
        int n2 = this.buffer.length;
        int n3 = this.remaining();
        return new StringBuilder(70).append("IntegerStack[0..(pos ").append(n).append(")..").append(n2).append(", remaining ").append(n3).append("]").toString();
    }

    public final int[] buffer() {
        return this.buffer;
    }

    private final void growIfNecessary(int n) throws IndexOutOfBoundsException {
        if (this.position + n > this.buffer.length) {
            if (0 >= this.growSize) {
                String string = String.valueOf(this);
                throw new IndexOutOfBoundsException(new StringBuilder(25 + String.valueOf(string).length()).append("Out of fixed stack size: ").append(string).toString());
            }
            int[] nArray = new int[this.buffer.length + this.growSize];
            System.arraycopy(this.buffer, 0, nArray, 0, this.position);
            this.buffer = nArray;
        }
    }

    public final int[] putOnTop(int[] nArray, int n, int n2) throws IndexOutOfBoundsException {
        this.growIfNecessary(n2);
        System.arraycopy(nArray, n, this.buffer, this.position, n2);
        this.position += n2;
        return nArray;
    }

    public final IntBuffer putOnTop(IntBuffer intBuffer, int n) throws IndexOutOfBoundsException, BufferUnderflowException {
        this.growIfNecessary(n);
        intBuffer.get(this.buffer, this.position, n);
        this.position += n;
        return intBuffer;
    }

    public final int[] getFromTop(int[] nArray, int n, int n2) throws IndexOutOfBoundsException {
        System.arraycopy(this.buffer, this.position - n2, nArray, n, n2);
        this.position -= n2;
        return nArray;
    }

    public final IntBuffer getFromTop(IntBuffer intBuffer, int n) throws IndexOutOfBoundsException, BufferOverflowException {
        intBuffer.put(this.buffer, this.position - n, n);
        this.position -= n;
        return intBuffer;
    }
}

