/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseJspFileImpl
extends PsiFileImpl
implements BaseJspFile {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.JspxFileImpl");
    private SoftReference<Map<JspDirectiveKind, XmlTag[]>> myDirectives;

    public BaseJspFileImpl(@NotNull JspxFileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "<init>"));
        }
        super((IElementType)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).getFileNodeType(), (IElementType)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).getFileNodeType(), (FileViewProvider)viewProvider);
        this.myDirectives = null;
    }

    public PsiFile getBaseLanguageRoot() {
        return this.getViewProvider().getPsi(this.getViewProvider().getTemplateDataLanguage());
    }

    public PsiElement[] getContentsElements() {
        XmlTag rootTag = this.getDocument().getRootTag();
        if (rootTag == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        if ("root".equals(rootTag.getLocalName()) && "http://java.sun.com/JSP/Page".equals(rootTag.getNamespace())) {
            return rootTag.getValue().getChildren();
        }
        return new PsiElement[]{rootTag};
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "accept"));
        }
        visitor.visitFile((PsiFile)this);
    }

    @NotNull
    public FileType getFileType() {
        Language language = this.getLanguage();
        if (language == Language.findInstance(NewJspLanguage.class)) {
            LanguageFileType languageFileType = StdFileTypes.JSP;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "getFileType"));
            }
            return languageFileType;
        }
        LanguageFileType languageFileType = StdFileTypes.JSPX;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "getFileType"));
        }
        return languageFileType;
    }

    public String toString() {
        return "JspxFile:" + this.getName();
    }

    public XmlDocument getDocument() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlDocument)) continue;
            return (XmlDocument)child;
        }
        return null;
    }

    @NotNull
    public XmlTag getRootTag() {
        XmlDocument document = this.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        XmlTag xmlTag = rootTag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "getRootTag"));
        }
        return xmlTag;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor, place);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myDirectives = null;
        if (this.getLanguage() == JSPXLanguage.INSTANCE) {
            ScriptSupportUtil.clearCaches((XmlFile)this);
        }
    }

    public boolean isErrorPage() {
        XmlTag[] directiveTags;
        for (XmlTag directiveTag : directiveTags = this.getDirectiveTags(JspDirectiveKind.PAGE, true)) {
            String isErrorPage = directiveTag.getAttributeValue("isErrorPage");
            if (isErrorPage == null) continue;
            return Boolean.parseBoolean(isErrorPage);
        }
        return false;
    }

    public PsiFile getErrorPage() {
        XmlTag[] directiveTags;
        for (XmlTag directiveTag : directiveTags = this.getDirectiveTags(JspDirectiveKind.PAGE, true)) {
            PsiReference[] references;
            XmlAttributeValue valueElement;
            XmlAttribute errorPage = directiveTag.getAttribute("errorPage", null);
            if (errorPage == null || (valueElement = errorPage.getValueElement()) == null) continue;
            for (PsiReference reference : references = valueElement.getReferences()) {
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiFile)) continue;
                return (PsiFile)element;
            }
        }
        return null;
    }

    public boolean isSessionPage() {
        XmlTag[] directiveTags;
        for (XmlTag directiveTag : directiveTags = this.getDirectiveTags(JspDirectiveKind.PAGE, true)) {
            String session = directiveTag.getAttributeValue("session");
            if (session == null) continue;
            return Boolean.parseBoolean(session);
        }
        return true;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getViewProvider().getBaseLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "getLanguage"));
        }
        return language;
    }

    public XmlTag[] getDirectiveTags(final JspDirectiveKind directiveKind, boolean searchInIncludes) {
        if (searchInIncludes) {
            final ArrayList<XmlTag> directives = new ArrayList<XmlTag>(Arrays.asList(this.getDirectiveTags(directiveKind, false)));
            this.visitAllIncludedFilesRecursively(this, new Processor<BaseJspFile>(){

                public boolean process(BaseJspFile jspFile) {
                    ContainerUtil.addAll((Collection)directives, (Object[])jspFile.getDirectiveTags(directiveKind, false));
                    return true;
                }
            });
            return (XmlTag[])ContainerUtil.toArray(directives, (Object[])new XmlTag[directives.size()]);
        }
        Map deref = (Map)SoftReference.dereference(this.myDirectives);
        if (deref != null) {
            XmlTag[] xmlTags = (XmlTag[])deref.get(directiveKind);
            return xmlTags == null ? XmlTag.EMPTY : xmlTags;
        }
        final EnumMap directivesMap = new EnumMap(JspDirectiveKind.class);
        XmlUtil.processXmlElements((XmlElement)this.getDocument(), (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                XmlTag xmlTag;
                JspDirectiveKind directiveKindByTag;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl$2", "execute"));
                }
                if (element instanceof XmlTag && (directiveKindByTag = BaseJspUtil.getDirectiveKindByTag(xmlTag = (XmlTag)element)) != null) {
                    ArrayList<XmlTag> xmlTags = (ArrayList<XmlTag>)directivesMap.get(directiveKindByTag);
                    if (xmlTags == null) {
                        xmlTags = new ArrayList<XmlTag>(10);
                        directivesMap.put(directiveKindByTag, xmlTags);
                    }
                    xmlTags.add(xmlTag);
                }
                return true;
            }
        }, (boolean)true);
        EnumMap<JspDirectiveKind, Object[]> directives = new EnumMap<JspDirectiveKind, Object[]>(JspDirectiveKind.class);
        for (Map.Entry entry : directivesMap.entrySet()) {
            List tags = (List)entry.getValue();
            directives.put((JspDirectiveKind)entry.getKey(), ContainerUtil.toArray((List)tags, (Object[])new XmlTag[tags.size()]));
        }
        this.myDirectives = new SoftReference(directives);
        return this.getDirectiveTags(directiveKind, false);
    }

    protected <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T baseJspFile, Processor<T> processor) {
        BaseJspUtil.visitAllIncludedFilesRecursively(baseJspFile, processor);
    }

    public XmlTag createDirective(XmlTag context, JspDirectiveKind directiveKind) {
        String localName = BaseJspUtil.getDirectiveAttributeName(directiveKind, this);
        XmlTag parent = context == null || this.getLanguage() == StdLanguages.JSP ? this.getRootTag() : context;
        LOG.assertTrue(parent != null);
        return parent.createChildTag(localName, "http://java.sun.com/JSP/Page", null, true);
    }

    public XmlTag createDirective(JspDirectiveKind directiveKind) {
        return this.createDirective(null, directiveKind);
    }

    public boolean isTagPage() {
        String name = this.getName();
        return BaseJspFileImpl.getExtension(name).startsWith("tag");
    }

    private static String getExtension(String name) {
        int extensionStart = name.lastIndexOf(46);
        String extension = "";
        if (extensionStart >= 0) {
            extension = name.substring(extensionStart + 1);
        }
        return extension;
    }

    @NotNull
    public JspxFileViewProvider getViewProvider() {
        JspxFileViewProvider jspxFileViewProvider = (JspxFileViewProvider)super.getViewProvider();
        if (jspxFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "getViewProvider"));
        }
        return jspxFileViewProvider;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "processDeclarations"));
        }
        boolean b = super.processDeclarations(processor, state, lastParent, place);
        if (b && this.getLanguage() == JSPXLanguage.INSTANCE) {
            b = ScriptSupportUtil.processDeclarations((XmlFile)this, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)lastParent, (PsiElement)place);
        }
        return b;
    }

    public boolean isTemplateDataFile() {
        return true;
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this);
        GlobalSearchScope globalSearchScope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(true) : GlobalSearchScope.allScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl", "getFileResolveScope"));
        }
        return globalSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }
}

