/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JstlUtil {
    private static final Key<CachedValue<XmlTag[]>> IMPORT_TAGS_KEY = Key.create((String)"IMPORT_TAGS_KEY");
    private static final Set<String> JSTL_CORE_URI_SET = new HashSet<String>(Arrays.asList(XmlUtil.JSTL_CORE_URIS));
    @NonNls
    private static final String IMPORT_TAG_NAME = "import";
    @NonNls
    private static final String URL_ATTRIBUTE = "url";

    public static XmlTag[] getImportTags(@NotNull BaseJspFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/jsp/JstlUtil", "getImportTags"));
        }
        CachedValue value = (CachedValue)file.getUserData(IMPORT_TAGS_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/jsp/JstlUtil", "lambda$getImportTags$0"));
                }
                return CachedValueProvider.Result.createSingleDependency((Object)JstlUtil.findImportTags(file), (Object)file);
            }, false);
            file.putUserData(IMPORT_TAGS_KEY, (Object)value);
        }
        return (XmlTag[])value.getValue();
    }

    private static XmlTag[] findImportTags(@NotNull BaseJspFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/jsp/JstlUtil", "findImportTags"));
        }
        final ArrayList tags = new ArrayList();
        XmlUtil.processXmlElements((XmlElement)file, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                XmlTag tag;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/jsp/JstlUtil$1", "execute"));
                }
                if (element instanceof XmlTag && JstlUtil.IMPORT_TAG_NAME.equals((tag = (XmlTag)element).getLocalName()) && JSTL_CORE_URI_SET.contains(tag.getNamespace())) {
                    tags.add(tag);
                }
                return true;
            }
        }, (boolean)true);
        return tags.toArray(new XmlTag[tags.size()]);
    }

    @Nullable
    public static PsiFile resolveImportTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/jsp/JstlUtil", "resolveImportTag"));
        }
        return JspUtil.resolvePsiFileReferenceInAttribute(tag, URL_ATTRIBUTE);
    }

    @Nullable
    public static String getImportFilePath(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/jsp/JstlUtil", "getImportFilePath"));
        }
        return tag.getAttributeValue(URL_ATTRIBUTE);
    }
}

