/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionFactory
implements FileCollectionFactory {
    @Override
    public FileCollection create(final TaskDependency builtBy, MinimalFileSet contents) {
        if (contents instanceof Buildable) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        return new FileCollectionAdapter(contents){

            public TaskDependency getBuildDependencies() {
                return builtBy;
            }
        };
    }

    @Override
    public FileCollection create(MinimalFileSet contents) {
        return new FileCollectionAdapter(contents);
    }

    @Override
    public FileCollection empty(String displayName) {
        return this.fixed(displayName, Collections.<File>emptyList());
    }

    @Override
    public FileCollection fixed(final String displayName, File ... files) {
        return new FileCollectionAdapter(new ListBackedFileSet(files){

            public String getDisplayName() {
                return displayName;
            }
        });
    }

    @Override
    public FileCollection fixed(final String displayName, Collection<File> files) {
        return new FileCollectionAdapter(new ListBackedFileSet(files){

            public String getDisplayName() {
                return displayName;
            }
        });
    }
}

