/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public abstract class JavaeeProjectDataService<E extends ExternalEntityData, FACET extends JavaeeFacet, FACET_CONFIG extends JavaeeFacetConfiguration, FACET_TYPE extends JavaeeFacetType<FACET, FACET_CONFIG>>
extends AbstractProjectDataService<E, Artifact> {
    private static final Logger LOG = Logger.getInstance(JavaeeProjectDataService.class);
    private static final boolean USE_PROJECT_OUTPUT_PATH = Boolean.getBoolean("idea.gradle.artifact.use.project.output");
    private final FACET_TYPE myJavaeeFacetType;

    public JavaeeProjectDataService(FACET_TYPE javaeeFacetType) {
        this.myJavaeeFacetType = javaeeFacetType;
    }

    protected abstract void configureJavaeeModule(@NotNull ModuleData var1, @NotNull E var2, @NotNull IdeModifiableModelsProvider var3);

    protected abstract ArtifactType getArtifactType(boolean var1);

    protected abstract Collection<String> resolveArtifactNames(@NotNull ModuleData var1, @NotNull E var2);

    public FACET_TYPE getJavaeeFacetType() {
        return this.myJavaeeFacetType;
    }

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "importData"));
        }
        if (this.myJavaeeFacetType == null) {
            return;
        }
        for (DataNode<E> node : toImport) {
            Object parentNodeData;
            DataNode parentNode;
            final ExternalEntityData data = (ExternalEntityData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)data.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            final ModuleData moduleData = (ModuleData)parentNodeData;
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                public void execute() {
                    JavaeeProjectDataService.this.configureJavaeeModule(moduleData, data, modelsProvider);
                }
            });
        }
    }

    @NotNull
    public Computable<Collection<Artifact>> computeOrphanData(@NotNull Collection<DataNode<E>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        Computable computable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$computeOrphanData$0"));
            }
            if (projectData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$computeOrphanData$0"));
            }
            if (toImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$computeOrphanData$0"));
            }
            if (modelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$computeOrphanData$0"));
            }
            List orphanArtifacts = ContainerUtil.newSmartList();
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectData.getOwner());
            List linkedProjectsPaths = ContainerUtil.map((Collection)settings.getLinkedProjectsSettings(), ExternalProjectSettings::getExternalProjectPath);
            List<String> importedArtifacts = this.resolveArtifactNames(toImport);
            ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
            for (Artifact artifact : artifactModel.getAllArtifactsIncludingInvalid()) {
                String externalProjectPath;
                Object state;
                if (!JavaeeProjectDataService.isGradleJeeArtifact(artifact, this.myJavaeeFacetType) || !((state = artifact.getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance()).getState()) instanceof GradleArtifactProperties) || linkedProjectsPaths.contains(externalProjectPath = ((GradleArtifactProperties)((Object)((Object)state))).getExternalProjectPath()) && (!projectData.getLinkedExternalProjectPath().equals(externalProjectPath) || importedArtifacts.contains(artifact.getName()))) continue;
                orphanArtifacts.add(artifact);
            }
            return orphanArtifacts;
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        return computable;
    }

    public void removeData(@NotNull Computable<Collection<Artifact>> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        List<String> ignoredArtifacts = this.resolveArtifactNames(toIgnore);
        List artifactsToRemove = ContainerUtil.newSmartList();
        artifactsToRemove.addAll((Collection)toRemove.compute());
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        for (Artifact artifact : artifactsToRemove) {
            artifactModel.removeArtifact(artifact);
        }
        for (Artifact artifact : (List)new GradleArtifactsFinder(artifactModel, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)this.myJavaeeFacetType).getValue()) {
            if (!ignoredArtifacts.contains(artifact.getName())) continue;
            artifactModel.removeArtifact(artifact);
        }
        if (this.myJavaeeFacetType != null) {
            List orphanFacets = ContainerUtil.newSmartList();
            String gradleFacetNamePrefix = this.getFacetNamePrefix((FacetType)this.myJavaeeFacetType);
            GradleArtifactsFinder gradleArtifactsFinder = new GradleArtifactsFinder(artifactModel, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)this.myJavaeeFacetType);
            List modules = ContainerUtil.filter((Object[])modelsProvider.getModules(), module -> {
                if (projectData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$removeData$1"));
                }
                return projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
            });
            PackagingElementResolvingContext context = modelsProvider.getPackagingElementResolvingContext();
            for (Module module2 : modules) {
                for (JavaeeFacet javaeeFacet : context.getFacetsProvider().getFacetsByType(module2, this.myJavaeeFacetType.getId())) {
                    if (!javaeeFacet.getName().startsWith(gradleFacetNamePrefix)) continue;
                    boolean used = false;
                    List artifacts = (List)gradleArtifactsFinder.getValue();
                    for (Artifact artifact : artifacts) {
                        if (!JavaeeProjectDataService.isUsedIn(javaeeFacet, artifact, context)) continue;
                        used = true;
                        break;
                    }
                    if (used) continue;
                    orphanFacets.add(javaeeFacet);
                }
            }
            for (JavaeeFacet orphanFacet : orphanFacets) {
                if (orphanFacet.isDisposed()) continue;
                Module orphanFacetModule = orphanFacet.getModule();
                ModifiableFacetModel modifiableFacetModel = modelsProvider.getModifiableFacetModel(orphanFacetModule);
                modifiableFacetModel.removeFacet((Facet)orphanFacet);
            }
        }
    }

    protected FACET createOrReplaceFacet(ModifiableFacetModel facetModel, Module module, String facetName, FACET_TYPE javaeeFacetType) {
        Collection facets = facetModel.getFacetsByType(javaeeFacetType.getId());
        for (JavaeeFacet facet : facets) {
            if (!facetName.equals(facet.getName())) continue;
            facetModel.removeFacet((Facet)facet);
            break;
        }
        JavaeeFacet facet = (JavaeeFacet)javaeeFacetType.createFacet(module, facetName, javaeeFacetType.createDefaultConfiguration(), null);
        facetModel.addFacet((Facet)facet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
        return (FACET)facet;
    }

    protected String getFacetNamePrefix(@NotNull FacetType facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "getFacetNamePrefix"));
        }
        return facetType.getPresentableName() + ' ' + GradleConstants.SYSTEM_ID.getReadableName();
    }

    @NotNull
    protected ModifiableArtifact prepareArtifact(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module, @NotNull String artifactName, @NotNull Jar jar, @NotNull ArtifactType artifactType) {
        String outputPath;
        CompositePackagingElement rootElement;
        ModifiableArtifact modifiableArtifact;
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "prepareArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "prepareArtifact"));
        }
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "prepareArtifact"));
        }
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "prepareArtifact"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "prepareArtifact"));
        }
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        Artifact artifact = artifactModel.findArtifact(artifactName);
        if (artifact == null || !artifact.getArtifactType().equals(artifactType)) {
            if (artifact != null) {
                artifactModel.removeArtifact(artifact);
            }
            modifiableArtifact = artifactModel.addArtifact(artifactName, artifactType, artifactType.createRootElement(artifactName), ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
            rootElement = modifiableArtifact.getRootElement();
        } else {
            modifiableArtifact = artifactModel.getOrCreateModifiableArtifact(artifact);
            rootElement = modifiableArtifact.getRootElement();
            rootElement.removeAllChildren();
        }
        if (rootElement instanceof ArchivePackagingElement) {
            ArchivePackagingElement archivePackagingElement = (ArchivePackagingElement)rootElement;
            archivePackagingElement.rename(jar.getName());
        }
        GradleArtifactProperties gradleArtifactProperties = new GradleArtifactProperties();
        gradleArtifactProperties.setExternalProjectPath(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
        modifiableArtifact.setProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance(), (ArtifactProperties)gradleArtifactProperties);
        boolean isExploded = false;
        if (artifactType instanceof JavaeeArtifactTypeBase) {
            boolean bl = isExploded = !((JavaeeArtifactTypeBase)artifactType).isArchive();
        }
        if ((outputPath = this.getArtifactOutputPath(artifactName, module, jar, isExploded)) != null) {
            modifiableArtifact.setOutputPath(outputPath);
            if (isExploded) {
                this.addManifest(modifiableArtifact, outputPath, jar);
            }
        }
        ModifiableArtifact modifiableArtifact2 = modifiableArtifact;
        if (modifiableArtifact2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "prepareArtifact"));
        }
        return modifiableArtifact2;
    }

    @Nullable
    protected String getArtifactOutputPath(String artifactName, Module module, Jar jar, boolean isExploded) {
        File outputFile;
        if (jar.getArchivePath() != null && !USE_PROJECT_OUTPUT_PATH) {
            return FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)(isExploded ? jar.getArchivePath().getParent() + "/exploded/" + jar.getArchivePath().getName() : jar.getArchivePath().getParent())));
        }
        String defaultArtifactOutputPath = ArtifactUtil.getDefaultArtifactOutputPath((String)artifactName, (Project)module.getProject());
        if (defaultArtifactOutputPath != null && (outputFile = new File(defaultArtifactOutputPath).getParentFile()) != null) {
            String outputPath = outputFile.getName().equals(module.getName()) ? outputFile.getPath() : outputFile.getPath() + '/' + StringUtil.trimEnd((String)module.getName(), (String)"_main");
            return FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)(isExploded ? outputPath + "/exploded/" + jar.getName() : outputPath)));
        }
        return null;
    }

    protected void addManifest(@NotNull ModifiableArtifact modifiableArtifact, @NotNull String outputPath, @NotNull Jar jar) {
        if (modifiableArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableArtifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "addManifest"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "addManifest"));
        }
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "addManifest"));
        }
        if (jar.getManifestContent() == null) {
            return;
        }
        ArtifactProperties artifactProperties = modifiableArtifact.getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance());
        if (artifactProperties == null || !(artifactProperties.getState() instanceof GradleArtifactProperties)) {
            return;
        }
        ((GradleArtifactProperties)((Object)artifactProperties.getState())).setManifest(Base64.getEncoder().encodeToString(jar.getManifestContent().getBytes(StandardCharsets.UTF_8)));
        String manifestPath = FileUtil.toSystemIndependentName((String)(outputPath + '/' + "META-INF/MANIFEST.MF"));
        PackagingElementFactory.getInstance().addFileCopy(modifiableArtifact.getRootElement(), ManifestFileUtil.MANIFEST_DIR_NAME, manifestPath, ManifestFileUtil.MANIFEST_FILE_NAME);
    }

    protected String resolveArtifactName(@NotNull ModuleData moduleData, @NotNull String archiveName, boolean isExploded) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactName"));
        }
        if (archiveName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveName", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactName"));
        }
        String artifactNamePrefix = GradleConstants.SYSTEM_ID.getReadableName();
        StringBuilder buf = new StringBuilder(artifactNamePrefix);
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(" : ").append(moduleData.getGroup());
        }
        String artifactName = this.adjustName(buf.toString(), archiveName);
        return isExploded ? artifactName + " (exploded)" : artifactName;
    }

    @NotNull
    protected String formatModuleArchiveFileName(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "formatModuleArchiveFileName"));
        }
        StringBuilder buf = new StringBuilder();
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(moduleData.getGroup()).append('-');
        }
        buf.append(StringUtil.trimEnd((String)moduleData.getExternalName(), (String)":main"));
        if (!StringUtil.isEmpty((String)moduleData.getVersion()) && !"unspecified".equals(moduleData.getVersion())) {
            buf.append('-').append(moduleData.getVersion());
        }
        String string = PathUtilRt.suggestFileName((String)buf.append(".jar").toString(), (boolean)true, (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "formatModuleArchiveFileName"));
        }
        return string;
    }

    protected String adjustName(@NotNull String namePrefix, @Nullable String archiveName) {
        if (namePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePrefix", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "adjustName"));
        }
        String buffer = namePrefix + (StringUtil.isEmpty((String)archiveName) ? "" : " : " + archiveName);
        return buffer.replace('/', '_');
    }

    private static boolean isUsedIn(@NotNull JavaeeFacet javaeeFacet, @NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context) {
        if (javaeeFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isUsedIn"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isUsedIn"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isUsedIn"));
        }
        Ref result = Ref.create((Object)Boolean.FALSE);
        ArtifactUtil.processPackagingElements((Artifact)artifact, null, element -> {
            Facet facet;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$isUsedIn$2"));
            }
            if (javaeeFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "lambda$isUsedIn$2"));
            }
            if (element instanceof FacetBasedPackagingElement && javaeeFacet.equals((Object)(facet = ((FacetBasedPackagingElement)element).findFacet(context)))) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }, (PackagingElementResolvingContext)context, (boolean)true);
        return (Boolean)result.get();
    }

    @NotNull
    private List<String> resolveArtifactNames(@NotNull Collection<DataNode<E>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactNames"));
        }
        List artifacts = ContainerUtil.newSmartList();
        for (DataNode<E> node : nodes) {
            Object parentNodeData;
            DataNode parentNode;
            ExternalEntityData earConfigurationModelData = (ExternalEntityData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)earConfigurationModelData.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)parentNodeData;
            artifacts.addAll(this.resolveArtifactNames(moduleData, earConfigurationModelData));
        }
        List list = artifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactNames"));
        }
        return list;
    }

    private static boolean isGradleJeeArtifact(@NotNull Artifact artifact, @NotNull JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isGradleJeeArtifact"));
        }
        if (javaeeFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isGradleJeeArtifact"));
        }
        boolean isOurType = false;
        for (ArtifactType artifactType : javaeeFacetType.getArtifactTypes()) {
            isOurType = isOurType || artifact.getArtifactType().equals(artifactType);
        }
        return isOurType && artifact.getName().startsWith(GradleConstants.SYSTEM_ID.getReadableName());
    }

    private static class GradleArtifactsFinder
    extends NotNullLazyValue<List<? extends Artifact>> {
        private final ModifiableArtifactModel myArtifactModel;
        private final JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> myJavaeeFacetType;

        public GradleArtifactsFinder(ModifiableArtifactModel artifactModel, JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
            this.myArtifactModel = artifactModel;
            this.myJavaeeFacetType = javaeeFacetType;
        }

        @NotNull
        protected List<? extends Artifact> compute() {
            List result = ContainerUtil.newSmartList();
            for (Artifact artifact : this.myArtifactModel.getAllArtifactsIncludingInvalid()) {
                if (!JavaeeProjectDataService.isGradleJeeArtifact(artifact, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)this.myJavaeeFacetType)) continue;
                result.add(artifact);
            }
            List list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService$GradleArtifactsFinder", "compute"));
            }
            return list;
        }
    }
}

