/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Beta
public class Project {
    protected final LintClient client;
    protected final File dir;
    protected final File referenceDir;
    protected Configuration configuration;
    protected String pkg;
    protected int buildSdk = -1;
    protected IAndroidTarget target;
    protected AndroidVersion manifestMinSdk = AndroidVersion.DEFAULT;
    protected AndroidVersion manifestTargetSdk = AndroidVersion.DEFAULT;
    protected boolean library;
    protected String name;
    protected String proguardPath;
    protected boolean mergeManifests;
    protected SdkInfo sdkInfo;
    protected List<File> files;
    protected List<File> proguardFiles;
    protected List<File> gradleFiles;
    protected List<File> manifestFiles;
    protected List<File> javaSourceFolders;
    protected List<File> javaClassFolders;
    protected List<File> nonProvidedJavaLibraries;
    protected List<File> javaLibraries;
    protected List<File> testSourceFolders;
    protected List<File> testLibraries;
    protected List<File> resourceFolders;
    protected List<File> assetFolders;
    protected List<Project> directLibraries;
    protected List<Project> allLibraries;
    protected boolean reportIssues = true;
    protected Boolean gradleProject;
    protected Boolean supportLib;
    protected Boolean appCompat;
    protected GradleVersion gradleVersion;
    private Map<String, String> superClassMap;
    private ResourceVisibilityLookup resourceVisibility;
    private BuildToolInfo buildTools;
    private static Boolean sAospBuild;
    private static AndroidVersion sCurrentVersion;
    private List<String> mCachedApplicableDensities;

    public static Project create(LintClient client, File dir, File referenceDir) {
        return new Project(client, dir, referenceDir);
    }

    public boolean isGradleProject() {
        if (this.gradleProject == null) {
            this.gradleProject = this.client.isGradleProject(this);
        }
        return this.gradleProject;
    }

    public boolean isAndroidProject() {
        return true;
    }

    public AndroidProject getGradleProjectModel() {
        return null;
    }

    public GradleVersion getGradleModelVersion() {
        AndroidProject gradleProjectModel;
        if (this.gradleVersion == null && this.isGradleProject() && (gradleProjectModel = this.getGradleProjectModel()) != null) {
            this.gradleVersion = GradleVersion.tryParse((String)gradleProjectModel.getModelVersion());
        }
        return this.gradleVersion;
    }

    public AndroidLibrary getGradleLibraryModel() {
        return null;
    }

    public Variant getCurrentVariant() {
        return null;
    }

    protected Project(LintClient client, File dir, File referenceDir) {
        this.client = client;
        this.dir = dir;
        this.referenceDir = referenceDir;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        block27: {
            try {
                Properties properties = new Properties();
                File propFile = new File(this.dir, "project.properties");
                if (!propFile.exists()) break block27;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(propFile));
                try {
                    String key;
                    String library;
                    properties.load(is);
                    String value = properties.getProperty("android.library");
                    this.library = "true".equals(value);
                    String proguardPath = properties.getProperty("proguard.config");
                    if (proguardPath != null) {
                        this.proguardPath = proguardPath;
                    }
                    this.mergeManifests = "true".equals(properties.getProperty("manifestmerger.enabled"));
                    String target = properties.getProperty("target");
                    if (target != null) {
                        int index = target.lastIndexOf(45);
                        if (index == -1) {
                            index = target.lastIndexOf(58);
                        }
                        if (index != -1) {
                            String versionString = target.substring(index + 1);
                            try {
                                this.buildSdk = Integer.parseInt(versionString);
                            }
                            catch (NumberFormatException nufe) {
                                this.client.log(Severity.WARNING, null, "Unexpected build target format: %1$s", target);
                            }
                        }
                    }
                    for (int i = 1; i < 1000 && (library = properties.getProperty(key = String.format("android.library.reference.%1$d", i))) != null; ++i) {
                        if (library.isEmpty()) {
                            break;
                        }
                        File libraryDir = new File(this.dir, library).getCanonicalFile();
                        if (this.directLibraries == null) {
                            this.directLibraries = new ArrayList<Project>();
                        }
                        File libraryReferenceDir = this.referenceDir;
                        if (!libraryDir.getPath().startsWith(this.referenceDir.getPath())) {
                            libraryReferenceDir = libraryReferenceDir.getCanonicalFile();
                            if (!libraryDir.getPath().startsWith(this.referenceDir.getPath())) {
                                for (File file = libraryReferenceDir; file != null && !file.getPath().isEmpty(); file = file.getParentFile()) {
                                    if (!libraryDir.getPath().startsWith(file.getPath())) continue;
                                    libraryReferenceDir = file;
                                    break;
                                }
                            }
                        }
                        try {
                            Project libraryPrj = this.client.getProject(libraryDir, libraryReferenceDir);
                            this.directLibraries.add(libraryPrj);
                            libraryPrj.setReportIssues(false);
                            continue;
                        }
                        catch (CircularDependencyException e) {
                            e.setProject(this);
                            e.setLocation(Location.create(propFile));
                            throw e;
                        }
                    }
                }
                finally {
                    try {
                        Closeables.close((Closeable)is, (boolean)true);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ioe) {
                this.client.log(ioe, "Initializing project state", new Object[0]);
            }
        }
        this.directLibraries = this.directLibraries != null ? Collections.unmodifiableList(this.directLibraries) : Collections.emptyList();
        if (Project.isAospBuildEnvironment()) {
            if (Project.isAospFrameworksRelatedProject(this.dir)) {
                this.manifestMinSdk = this.manifestTargetSdk = new AndroidVersion(25, null);
            } else if (this.buildSdk == -1) {
                this.buildSdk = this.getClient().getHighestKnownApiLevel();
            }
        }
    }

    public String toString() {
        return "Project [dir=" + this.dir + ']';
    }

    public int hashCode() {
        return this.dir.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return this.dir.equals(other.dir);
    }

    public void addFile(File file) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(file);
    }

    public List<File> getSubset() {
        return this.files;
    }

    public List<File> getJavaSourceFolders() {
        if (this.javaSourceFolders == null) {
            if (Project.isAospFrameworksRelatedProject(this.dir)) {
                return Collections.singletonList(new File(this.dir, "java"));
            }
            if (Project.isAospBuildEnvironment()) {
                String top = Project.getAospTop();
                if (this.dir.getAbsolutePath().startsWith(top)) {
                    this.javaSourceFolders = this.getAospJavaSourcePath();
                    return this.javaSourceFolders;
                }
            }
            this.javaSourceFolders = this.client.getJavaSourceFolders(this);
        }
        return this.javaSourceFolders;
    }

    public List<File> getJavaClassFolders() {
        if (this.javaClassFolders == null) {
            String relative;
            File jar;
            File out;
            String top;
            if (Project.isAospFrameworksProject(this.dir) && (top = Project.getAospTop()) != null && (out = new File(top, "out")).exists() && (jar = new File(out, (relative = "target/common/obj/JAVA_LIBRARIES/framework_intermediates/classes.jar").replace('/', File.separatorChar))).exists()) {
                this.javaClassFolders = Collections.singletonList(jar);
                return this.javaClassFolders;
            }
            if (Project.isAospBuildEnvironment()) {
                top = Project.getAospTop();
                if (this.dir.getAbsolutePath().startsWith(top)) {
                    this.javaClassFolders = this.getAospJavaClassPath();
                    return this.javaClassFolders;
                }
            }
            this.javaClassFolders = this.client.getJavaClassFolders(this);
        }
        return this.javaClassFolders;
    }

    public List<File> getJavaLibraries(boolean includeProvided) {
        if (includeProvided) {
            if (this.javaLibraries == null) {
                String relative;
                File out;
                File annotationsDir;
                this.javaLibraries = this.client.getJavaLibraries(this, true);
                if (Project.isAospBuildEnvironment() && (annotationsDir = new File(out = new File(Project.getAospTop(), "out"), (relative = "target/common/obj/JAVA_LIBRARIES/android-support-annotations_intermediates/classes").replace('/', File.separatorChar))).exists()) {
                    this.javaLibraries.add(annotationsDir);
                }
            }
            return this.javaLibraries;
        }
        if (this.nonProvidedJavaLibraries == null) {
            this.nonProvidedJavaLibraries = this.client.getJavaLibraries(this, false);
        }
        return this.nonProvidedJavaLibraries;
    }

    public List<File> getTestSourceFolders() {
        if (this.testSourceFolders == null) {
            this.testSourceFolders = this.client.getTestSourceFolders(this);
        }
        return this.testSourceFolders;
    }

    public List<File> getTestLibraries() {
        if (this.testLibraries == null) {
            this.testLibraries = this.client.getTestLibraries(this);
        }
        return this.testLibraries;
    }

    public List<File> getResourceFolders() {
        if (this.resourceFolders == null) {
            List<File> folders = this.client.getResourceFolders(this);
            if (folders.size() == 1 && Project.isAospFrameworksRelatedProject(this.dir)) {
                this.manifestMinSdk = this.manifestTargetSdk = new AndroidVersion(25, null);
                File folder = new File(folders.get(0), "res");
                if (!folder.exists()) {
                    folders = Collections.emptyList();
                }
            }
            this.resourceFolders = folders;
        }
        return this.resourceFolders;
    }

    public List<File> getAssetFolders() {
        if (this.assetFolders == null) {
            this.assetFolders = this.client.getAssetFolders(this);
        }
        return this.assetFolders;
    }

    public String getDisplayPath(File file) {
        String referencePath;
        String path = file.getPath();
        if (path.startsWith(referencePath = this.referenceDir.getPath())) {
            int length = referencePath.length();
            if (path.length() > length && path.charAt(length) == File.separatorChar) {
                ++length;
            }
            return path.substring(length);
        }
        return path;
    }

    public String getRelativePath(File file) {
        String referencePath;
        String path = file.getPath();
        if (path.startsWith(referencePath = this.dir.getPath())) {
            int length = referencePath.length();
            if (path.length() > length && path.charAt(length) == File.separatorChar) {
                ++length;
            }
            return path.substring(length);
        }
        return path;
    }

    public File getDir() {
        return this.dir;
    }

    public File getReferenceDir() {
        return this.referenceDir;
    }

    public Configuration getConfiguration(LintDriver driver) {
        if (this.configuration == null) {
            this.configuration = this.client.getConfiguration(this, driver);
        }
        return this.configuration;
    }

    public String getPackage() {
        return this.pkg;
    }

    public AndroidVersion getMinSdkVersion() {
        return this.manifestMinSdk == null ? AndroidVersion.DEFAULT : this.manifestMinSdk;
    }

    public int getMinSdk() {
        AndroidVersion version = this.getMinSdkVersion();
        return version == AndroidVersion.DEFAULT ? -1 : version.getApiLevel();
    }

    public AndroidVersion getTargetSdkVersion() {
        return this.manifestTargetSdk == AndroidVersion.DEFAULT ? this.getMinSdkVersion() : this.manifestTargetSdk;
    }

    public int getTargetSdk() {
        AndroidVersion version = this.getTargetSdkVersion();
        return version == AndroidVersion.DEFAULT ? -1 : version.getApiLevel();
    }

    public int getBuildSdk() {
        return this.buildSdk;
    }

    public BuildToolInfo getBuildTools() {
        if (this.buildTools == null) {
            this.buildTools = this.client.getBuildTools(this);
        }
        return this.buildTools;
    }

    public IAndroidTarget getBuildTarget() {
        if (this.target == null) {
            this.target = this.client.getCompileTarget(this);
        }
        return this.target;
    }

    public void readManifest(Document document) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        this.pkg = root.getAttribute("package");
        this.manifestMinSdk = AndroidVersion.DEFAULT;
        this.manifestTargetSdk = AndroidVersion.DEFAULT;
        NodeList usesSdks = root.getElementsByTagName("uses-sdk");
        if (usesSdks.getLength() > 0) {
            Element element = (Element)usesSdks.item(0);
            String minSdk = null;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                minSdk = element.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
            }
            if (minSdk != null) {
                IAndroidTarget[] targets = this.client.getTargets();
                this.manifestMinSdk = SdkVersionInfo.getVersion((String)minSdk, (IAndroidTarget[])targets);
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                String targetSdk = element.getAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                if (targetSdk != null) {
                    IAndroidTarget[] targets = this.client.getTargets();
                    this.manifestTargetSdk = SdkVersionInfo.getVersion((String)targetSdk, (IAndroidTarget[])targets);
                }
            } else {
                this.manifestTargetSdk = this.manifestMinSdk;
            }
        } else if (Project.isAospBuildEnvironment()) {
            this.extractAospMinSdkVersion();
            this.manifestTargetSdk = this.manifestMinSdk;
        }
    }

    public boolean isLibrary() {
        return this.library;
    }

    public List<Project> getDirectLibraries() {
        return this.directLibraries != null ? this.directLibraries : Collections.emptyList();
    }

    public List<Project> getAllLibraries() {
        if (this.allLibraries == null) {
            if (this.directLibraries.isEmpty()) {
                return this.directLibraries;
            }
            ArrayList<Project> all = new ArrayList<Project>();
            HashSet seen = Sets.newHashSet();
            HashSet path = Sets.newHashSet();
            seen.add(this);
            path.add(this);
            this.addLibraryProjects(all, seen, path);
            this.allLibraries = all;
        }
        return this.allLibraries;
    }

    private void addLibraryProjects(Collection<Project> collection, Set<Project> seen, Set<Project> path) {
        for (Project library : this.directLibraries) {
            if (seen.contains(library)) {
                if (!path.contains(library)) continue;
                this.client.log(Severity.WARNING, null, "Internal lint error: cyclic library dependency for %1$s", library);
                continue;
            }
            collection.add(library);
            seen.add(library);
            path.add(library);
            library.addLibraryProjects(collection, seen, path);
            path.remove(library);
        }
    }

    public SdkInfo getSdkInfo() {
        if (this.sdkInfo == null) {
            this.sdkInfo = this.client.getSdkInfo(this);
        }
        return this.sdkInfo;
    }

    public List<File> getManifestFiles() {
        if (this.manifestFiles == null) {
            File manifestFile = new File(this.dir, "AndroidManifest.xml");
            this.manifestFiles = manifestFile.exists() ? Collections.singletonList(manifestFile) : Collections.emptyList();
        }
        return this.manifestFiles;
    }

    public List<File> getProguardFiles() {
        if (this.proguardFiles == null) {
            ArrayList<File> files = new ArrayList<File>();
            if (this.proguardPath != null) {
                Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)":;"));
                for (String path : splitter.split((CharSequence)this.proguardPath)) {
                    if (path.contains("${")) continue;
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(this.getDir(), path);
                    }
                    if (!file.exists()) continue;
                    files.add(file);
                }
            }
            if (files.isEmpty()) {
                File file = new File(this.getDir(), "proguard.cfg");
                if (file.exists()) {
                    files.add(file);
                }
                if ((file = new File(this.getDir(), "proguard-project.txt")).exists()) {
                    files.add(file);
                }
            }
            this.proguardFiles = files;
        }
        return this.proguardFiles;
    }

    public List<File> getGradleBuildScripts() {
        if (this.gradleFiles == null) {
            if (this.isGradleProject()) {
                File settings;
                this.gradleFiles = Lists.newArrayListWithExpectedSize((int)2);
                File build = new File(this.dir, "build.gradle");
                if (build.exists()) {
                    this.gradleFiles.add(build);
                }
                if ((settings = new File(this.dir, "settings.gradle")).exists()) {
                    this.gradleFiles.add(settings);
                }
            } else {
                this.gradleFiles = Collections.emptyList();
            }
        }
        return this.gradleFiles;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.client.getProjectName(this);
        }
        return this.name;
    }

    public void setName(String name) {
        assert (!name.isEmpty());
        this.name = name;
    }

    public void setReportIssues(boolean reportIssues) {
        this.reportIssues = reportIssues;
    }

    public boolean getReportIssues() {
        return this.reportIssues;
    }

    public boolean isMergingManifests() {
        return this.mergeManifests;
    }

    public static boolean isAospBuildEnvironment() {
        if (sAospBuild == null) {
            sAospBuild = Project.getAospTop() != null;
        }
        return sAospBuild;
    }

    public static boolean isAospFrameworksRelatedProject(File dir) {
        if (Project.isAospBuildEnvironment()) {
            File frameworks = new File(Project.getAospTop(), "frameworks");
            String frameworksDir = frameworks.getAbsolutePath();
            String supportDir = new File(frameworks, "support").getAbsolutePath();
            if (dir.exists() && !dir.getAbsolutePath().startsWith(supportDir) && dir.getAbsolutePath().startsWith(frameworksDir) && !new File(dir, "AndroidManifest.xml").exists()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAospFrameworksProject(File dir) {
        String top = Project.getAospTop();
        if (top != null) {
            File toCompare = new File(top, "frameworks" + File.separator + "base" + File.separator + "core");
            try {
                return dir.getCanonicalFile().equals(toCompare) && dir.exists();
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private static String getAospTop() {
        return System.getenv("ANDROID_BUILD_TOP");
    }

    private static String getAospHostOut() {
        return System.getenv("ANDROID_HOST_OUT");
    }

    private static String getAospProductOut() {
        return System.getenv("ANDROID_PRODUCT_OUT");
    }

    private List<File> getAospJavaSourcePath() {
        ArrayList<File> sources = new ArrayList<File>(2);
        File src = new File(this.dir, "src");
        if (src.exists()) {
            sources.add(src);
        }
        for (File dir : this.getIntermediateDirs()) {
            File classes = new File(dir, "src");
            if (!classes.exists()) continue;
            sources.add(classes);
        }
        if (sources.isEmpty()) {
            this.client.log(null, "Warning: Could not find sources or generated sources for project %1$s", this.getName());
        }
        return sources;
    }

    private List<File> getAospJavaClassPath() {
        ArrayList<File> classDirs = new ArrayList<File>(1);
        for (File dir : this.getIntermediateDirs()) {
            File classes = new File(dir, "classes");
            if (classes.exists()) {
                classDirs.add(classes);
                continue;
            }
            classes = new File(dir, "classes.jar");
            if (!classes.exists()) continue;
            classDirs.add(classes);
        }
        if (classDirs.isEmpty()) {
            this.client.log(null, "No bytecode found: Has the project been built? (%1$s)", this.getName());
        }
        return classDirs;
    }

    private List<File> getIntermediateDirs() {
        ArrayList<File> intermediates = new ArrayList<File>();
        String moduleName = this.dir.getName();
        try {
            moduleName = this.dir.getCanonicalFile().getName();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String top = Project.getAospTop();
        String[] outFolders = new String[]{top + "/out/host/common/obj", top + "/out/target/common/obj", Project.getAospHostOut() + "/obj", Project.getAospProductOut() + "/obj"};
        String[] moduleClasses = new String[]{"APPS", "JAVA_LIBRARIES"};
        for (String out : outFolders) {
            assert (new File(out.replace('/', File.separatorChar)).exists()) : out;
            for (String moduleClass : moduleClasses) {
                String path = out + '/' + moduleClass + '/' + moduleName + "_intermediates";
                File file = new File(path.replace('/', File.separatorChar));
                if (!file.exists()) continue;
                intermediates.add(file);
            }
        }
        return intermediates;
    }

    private void extractAospMinSdkVersion() {
        boolean found = false;
        File makefile = new File(this.dir, "Android.mk");
        if (makefile.exists()) {
            try {
                List lines = Files.readLines((File)makefile, (Charset)Charsets.UTF_8);
                Pattern p = Pattern.compile("LOCAL_SDK_VERSION\\s*:=\\s*(.*)");
                for (String line : lines) {
                    Matcher matcher = p.matcher(line = line.trim());
                    if (!matcher.matches()) continue;
                    found = true;
                    String version = matcher.group(1);
                    this.manifestMinSdk = version.equals("current") ? Project.findCurrentAospVersion() : SdkVersionInfo.getVersion((String)version, (IAndroidTarget[])this.client.getTargets());
                    break;
                }
            }
            catch (IOException ioe) {
                this.client.log(ioe, null, new Object[0]);
            }
        }
        if (!found) {
            this.manifestMinSdk = Project.findCurrentAospVersion();
        }
    }

    private static AndroidVersion findCurrentAospVersion() {
        if (sCurrentVersion == null) {
            File versionMk = new File(Project.getAospTop(), "build/core/version_defaults.mk".replace('/', File.separatorChar));
            if (!versionMk.exists()) {
                sCurrentVersion = AndroidVersion.DEFAULT;
                return sCurrentVersion;
            }
            int sdkVersion = 9;
            try {
                Pattern p = Pattern.compile("PLATFORM_SDK_VERSION\\s*:=\\s*(.*)");
                List lines = Files.readLines((File)versionMk, (Charset)Charsets.UTF_8);
                for (String line : lines) {
                    Matcher matcher = p.matcher(line = line.trim());
                    if (!matcher.matches()) continue;
                    String version = matcher.group(1);
                    try {
                        sdkVersion = Integer.parseInt(version);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sCurrentVersion = new AndroidVersion(sdkVersion, null);
        }
        return sCurrentVersion;
    }

    public Boolean dependsOn(String artifact) {
        if ("com.android.support:support-v4".equals(artifact)) {
            if (this.supportLib == null) {
                for (File file : this.getJavaLibraries(true)) {
                    String name = file.getName();
                    if (!name.equals("android-support-v4.jar") && !name.startsWith("support-v4-")) continue;
                    this.supportLib = true;
                    break;
                }
                if (this.supportLib == null) {
                    for (Project dependency : this.getDirectLibraries()) {
                        Boolean b = dependency.dependsOn(artifact);
                        if (b == null || !b.booleanValue()) continue;
                        this.supportLib = true;
                        break;
                    }
                }
                if (this.supportLib == null) {
                    this.supportLib = false;
                }
            }
            return this.supportLib;
        }
        if ("com.android.support:appcompat-v7".equals(artifact)) {
            if (this.appCompat == null) {
                for (File file : this.getJavaLibraries(true)) {
                    String name = file.getName();
                    if (!name.startsWith("appcompat-v7-")) continue;
                    this.appCompat = true;
                    break;
                }
                if (this.appCompat == null) {
                    for (Project dependency : this.getDirectLibraries()) {
                        Boolean b = dependency.dependsOn(artifact);
                        if (b == null || !b.booleanValue()) continue;
                        this.appCompat = true;
                        break;
                    }
                }
                if (this.appCompat == null) {
                    this.appCompat = false;
                }
            }
            return this.appCompat;
        }
        return null;
    }

    public List<String> getApplicableDensities() {
        if (this.mCachedApplicableDensities == null) {
            if (this.isGradleProject() && this.getGradleProjectModel() != null && this.getCurrentVariant() != null) {
                HashSet relevantDensities = Sets.newHashSet();
                Variant variant = this.getCurrentVariant();
                List<String> variantFlavors = variant.getProductFlavors();
                AndroidProject gradleProjectModel = this.getGradleProjectModel();
                Project.addResConfigsFromFlavor(relevantDensities, null, this.getGradleProjectModel().getDefaultConfig());
                for (ProductFlavorContainer container : gradleProjectModel.getProductFlavors()) {
                    Project.addResConfigsFromFlavor(relevantDensities, variantFlavors, container);
                }
                if (relevantDensities.isEmpty()) {
                    AndroidArtifact mainArtifact = variant.getMainArtifact();
                    Collection<AndroidArtifactOutput> outputs = mainArtifact.getOutputs();
                    for (AndroidArtifactOutput output : outputs) {
                        for (OutputFile outputFile : output.getOutputs()) {
                            String DENSITY_NAME = OutputFile.FilterType.DENSITY.name();
                            if (!outputFile.getFilterTypes().contains(DENSITY_NAME)) continue;
                            for (FilterData data : outputFile.getFilters()) {
                                if (!DENSITY_NAME.equals(data.getFilterType())) continue;
                                relevantDensities.add(data.getIdentifier());
                            }
                        }
                    }
                }
                if (!relevantDensities.isEmpty()) {
                    this.mCachedApplicableDensities = Lists.newArrayListWithExpectedSize((int)10);
                    for (String density : relevantDensities) {
                        String folder = ResourceFolderType.DRAWABLE.getName() + '-' + density;
                        this.mCachedApplicableDensities.add(folder);
                    }
                    Collections.sort(this.mCachedApplicableDensities);
                } else {
                    this.mCachedApplicableDensities = Collections.emptyList();
                }
            } else {
                this.mCachedApplicableDensities = Collections.emptyList();
            }
        }
        return this.mCachedApplicableDensities.isEmpty() ? null : this.mCachedApplicableDensities;
    }

    public Map<String, String> getSuperClassMap() {
        if (this.superClassMap == null) {
            this.superClassMap = this.client.createSuperClassMap(this);
        }
        return this.superClassMap;
    }

    private static void addResConfigsFromFlavor(Set<String> relevantDensities, List<String> variantFlavors, ProductFlavorContainer container) {
        ProductFlavor flavor = container.getProductFlavor();
        if ((variantFlavors == null || variantFlavors.contains(flavor.getName())) && !flavor.getResourceConfigurations().isEmpty()) {
            for (String densityName : flavor.getResourceConfigurations()) {
                Density density = Density.getEnum((String)densityName);
                if (density == null || !density.isRecommended() || density == Density.NODPI || density == Density.ANYDPI) continue;
                relevantDensities.add(densityName);
            }
        }
    }

    public ResourceVisibilityLookup getResourceVisibility() {
        if (this.resourceVisibility == null) {
            if (this.isGradleProject()) {
                AndroidProject project = this.getGradleProjectModel();
                Variant variant = this.getCurrentVariant();
                if (project != null && variant != null) {
                    this.resourceVisibility = this.client.getResourceVisibilityProvider().get(project, variant);
                } else if (this.getGradleLibraryModel() != null) {
                    try {
                        this.resourceVisibility = this.client.getResourceVisibilityProvider().get(this.getGradleLibraryModel());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.resourceVisibility == null) {
                this.resourceVisibility = ResourceVisibilityLookup.NONE;
            }
        }
        return this.resourceVisibility;
    }

    public LintClient getClient() {
        return this.client;
    }
}

