/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAopInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/aop/jam/AbstractAopInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLiteralExpression || element instanceof XmlAttributeValue) {
                    AbstractAopInspection.this.checkElement(element, holder);
                } else if (element instanceof AopPointcutExpressionHolder && !(element instanceof AopPointcutExpressionFile)) {
                    AbstractAopInspection.this.checkElement((AopPointcutExpressionHolder)element, holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AbstractAopInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    protected void checkElement(PsiElement element, ProblemsHolder holder) {
        InjectedLanguageUtil.enumerate((PsiElement)element, (PsiFile)holder.getFile(), (boolean)true, (file, places) -> {
            if (file instanceof AopPointcutExpressionFile && file.getContext() == element) {
                this.checkElement((AopPointcutExpressionFile)file, holder);
            }
        });
    }

    protected void checkElement(AopPointcutExpressionHolder aopFile, ProblemsHolder holder) {
        LocalAopModel model = aopFile.getAopModel();
        PsiMethod method = model.getPointcutMethod();
        if (method != null) {
            this.checkAopMethod(method, model, holder, aopFile);
        }
    }

    protected abstract void checkAopMethod(PsiMethod var1, LocalAopModel var2, ProblemsHolder var3, AopPointcutExpressionHolder var4);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AopBundle.message("inspection.group.display.name.aop", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AbstractAopInspection", "getGroupDisplayName"));
        }
        return string;
    }
}

