/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.checks.ApiClass;
import com.android.tools.klint.checks.ApiPackage;
import com.android.tools.klint.checks.ApiParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Api {
    private final Map<String, ApiClass> mClasses;
    private final Map<String, ApiPackage> mPackages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Api parseApi(File apiFile) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(apiFile);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            ApiParser apiParser = new ApiParser();
            parser.parse(inputStream, (DefaultHandler)apiParser);
            inputStream.close();
            inputStream = Api.class.getResourceAsStream("api-versions-support-library.xml");
            if (inputStream != null) {
                parser.parse(inputStream, (DefaultHandler)apiParser);
            }
            Api api = new Api(apiParser.getClasses(), apiParser.getPackages());
            return api;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private Api(@NonNull Map<String, ApiClass> classes2, @NonNull Map<String, ApiPackage> packages) {
        this.mClasses = new HashMap<String, ApiClass>(classes2);
        this.mPackages = new HashMap<String, ApiPackage>(packages);
    }

    ApiClass getClass(String fqcn) {
        return this.mClasses.get(fqcn);
    }

    Map<String, ApiClass> getClasses() {
        return Collections.unmodifiableMap(this.mClasses);
    }

    Map<String, ApiPackage> getPackages() {
        return Collections.unmodifiableMap(this.mPackages);
    }
}

