/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.inspections.klint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

class IntellijLintProject
extends Project {
    public static final boolean SUPPORT_CLASS_FILES = false;
    protected AndroidVersion mMinSdkVersion;
    protected AndroidVersion mTargetSdkVersion;

    IntellijLintProject(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir) {
        super(client, dir, referenceDir);
    }

    @NonNull
    public static List<Project> create(@NonNull IntellijLintClient client, @Nullable List<VirtualFile> files, Module ... modules) {
        ArrayList projects = Lists.newArrayList();
        HashMap projectMap = Maps.newHashMap();
        HashMap moduleMap = Maps.newHashMap();
        HashMap libraryMap = Maps.newHashMap();
        if (files != null && !files.isEmpty()) {
            files = Lists.newArrayList(files);
        }
        for (Module module : modules) {
            IntellijLintProject.addProjects(client, module, files, moduleMap, libraryMap, projectMap, projects);
        }
        client.setModuleMap(projectMap);
        if (projects.size() > 1) {
            HashSet roots = new HashSet(projects);
            for (Project project : projects) {
                roots.removeAll(project.getAllLibraries());
            }
            return Lists.newArrayList(roots);
        }
        return projects;
    }

    @NonNull
    public static Pair<Project, Project> createForSingleFile(@NonNull IntellijLintClient client, @Nullable VirtualFile file, @NonNull Module module) {
        LintModuleProject project = IntellijLintProject.createModuleProject(client, module);
        LintModuleProject main = null;
        HashMap projectMap = Maps.newHashMap();
        if (project != null) {
            Module androidModule;
            project.setDirectLibraries(Collections.emptyList());
            if (file != null) {
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            projectMap.put(project, module);
            if (!project.isAndroidProject() && (androidModule = IntellijLintProject.findAndroidModule(module)) != null && (main = IntellijLintProject.createModuleProject(client, androidModule)) != null) {
                projectMap.put(main, androidModule);
                main.setDirectLibraries(Collections.singletonList(project));
            }
        }
        client.setModuleMap(projectMap);
        return Pair.create((Object)project, main);
    }

    @Nullable
    private static Module findAndroidModule(final @NonNull Module module) {
        Graph graph = (Graph)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Graph<Module>>(){

            public Graph<Module> compute() {
                com.intellij.openapi.project.Project project = module.getProject();
                if (project.isDisposed()) {
                    return null;
                }
                return ModuleManager.getInstance((com.intellij.openapi.project.Project)project).moduleGraph();
            }
        });
        if (graph == null) {
            return null;
        }
        HashSet facets = Sets.newHashSet();
        HashSet seen = Sets.newHashSet();
        seen.add(module);
        IntellijLintProject.addAndroidModules(facets, seen, (Graph<Module>)graph, module);
        for (AndroidFacet facet : facets) {
            if (facet.isLibraryProject()) continue;
            return facet.getModule();
        }
        if (!facets.isEmpty()) {
            return ((AndroidFacet)facets.iterator().next()).getModule();
        }
        return null;
    }

    private static void addAndroidModules(Set<AndroidFacet> androidFacets, Set<Module> seen, Graph<Module> graph, Module module) {
        Iterator iterator = graph.getOut((Object)module);
        while (iterator.hasNext()) {
            Module dep = (Module)iterator.next();
            AndroidFacet facet = AndroidFacet.getInstance((Module)dep);
            if (facet != null) {
                androidFacets.add(facet);
            }
            if (seen.contains(dep)) continue;
            seen.add(dep);
            IntellijLintProject.addAndroidModules(androidFacets, seen, graph, dep);
        }
    }

    private static void addProjects(@NonNull LintClient client, @NonNull Module module, @Nullable List<VirtualFile> files, @NonNull Map<Module, Project> moduleMap, @NonNull Map<AndroidLibrary, Project> libraryMap, @NonNull Map<Project, Module> projectMap, @NonNull List<Project> projects) {
        AndroidModuleModel androidModuleModel;
        if (moduleMap.containsKey(module)) {
            return;
        }
        LintModuleProject project = IntellijLintProject.createModuleProject(client, module);
        if (project == null) {
            List dependentFacets = AndroidUtils.getAllAndroidDependencies((Module)module, (boolean)false);
            for (AndroidFacet dependentFacet : dependentFacets) {
                IntellijLintProject.addProjects(client, dependentFacet.getModule(), files, moduleMap, libraryMap, projectMap, projects);
            }
            return;
        }
        projects.add(project);
        moduleMap.put(module, project);
        projectMap.put(project, module);
        if (IntellijLintProject.processFileFilter(module, files, project)) {
            return;
        }
        ArrayList dependencies = Lists.newArrayList();
        List dependentFacets = AndroidUtils.getAllAndroidDependencies((Module)module, (boolean)true);
        for (AndroidFacet dependentFacet : dependentFacets) {
            Project p = moduleMap.get(dependentFacet.getModule());
            if (p != null) {
                dependencies.add(p);
                continue;
            }
            IntellijLintProject.addProjects(client, dependentFacet.getModule(), files, moduleMap, libraryMap, projectMap, dependencies);
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null && (androidModuleModel = AndroidModuleModel.get((AndroidFacet)facet)) != null) {
            IntellijLintProject.addGradleLibraryProjects(client, files, libraryMap, projects, facet, androidModuleModel, project, projectMap, dependencies);
        }
        project.setDirectLibraries(dependencies);
    }

    private static boolean processFileFilter(@NonNull Module module, @Nullable List<VirtualFile> files, @NonNull LintModuleProject project) {
        if (files != null && !files.isEmpty()) {
            ListIterator<VirtualFile> iterator = files.listIterator();
            while (iterator.hasNext()) {
                VirtualFile file = iterator.next();
                if (!module.getModuleContentScope().accept(file)) continue;
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                iterator.remove();
            }
            if (files.isEmpty()) {
                project.setDirectLibraries(Collections.emptyList());
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LintModuleProject createModuleProject(@NonNull LintClient client, @NonNull Module module) {
        File dir;
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null) {
            VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot((AndroidFacet)facet);
            if (mainContentRoot == null) {
                return null;
            }
            dir = new File(FileUtil.toSystemDependentName((String)mainContentRoot.getPath()));
        } else {
            String moduleDirPath = AndroidRootUtil.getModuleDirPath((Module)module);
            if (moduleDirPath == null) {
                return null;
            }
            dir = new File(FileUtil.toSystemDependentName((String)moduleDirPath));
        }
        LintModuleProject project = null;
        if (facet == null) {
            project = new LintModuleProject(client, dir, dir, module);
            AndroidFacet f = IntellijLintProject.findAndroidFacetInProject(module.getProject());
            if (f != null) {
                project.mGradleProject = f.requiresAndroidModel();
            }
        } else {
            AndroidModel androidModel;
            project = facet.requiresAndroidModel() ? ((androidModel = facet.getAndroidModel()) instanceof AndroidModuleModel ? new LintGradleProject(client, dir, dir, facet, (AndroidModuleModel)androidModel) : new LintAndroidModelProject(client, dir, dir, facet, androidModel)) : new LintAndroidProject(client, dir, dir, facet);
        }
        if (project != null) {
            client.registerProject(dir, project);
        }
        return project;
    }

    public static boolean hasAndroidModule(@NonNull com.intellij.openapi.project.Project project) {
        return IntellijLintProject.findAndroidFacetInProject(project) != null;
    }

    @Nullable
    private static AndroidFacet findAndroidFacetInProject(@NonNull com.intellij.openapi.project.Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((com.intellij.openapi.project.Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null) continue;
            return facet;
        }
        return null;
    }

    private static void addGradleLibraryProjects(@NonNull LintClient client, @Nullable List<VirtualFile> files, @NonNull Map<AndroidLibrary, Project> libraryMap, @NonNull List<Project> projects, @NonNull AndroidFacet facet, @NonNull AndroidModuleModel AndroidModuleModel2, @NonNull LintModuleProject project, @NonNull Map<Project, Module> projectMap, @NonNull List<Project> dependencies) {
        Collection libraries = AndroidModuleModel2.getMainArtifact().getDependencies().getLibraries();
        for (AndroidLibrary library : libraries) {
            Project p = libraryMap.get(library);
            if (p == null) {
                File dir = library.getFolder();
                p = new LintGradleLibraryProject(client, dir, dir, library);
                libraryMap.put(library, p);
                projectMap.put(p, facet.getModule());
                projects.add(p);
                if (files != null) {
                    VirtualFile libraryDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
                    if (libraryDir != null) {
                        ListIterator<VirtualFile> iterator = files.listIterator();
                        while (iterator.hasNext()) {
                            VirtualFile file = iterator.next();
                            if (!VfsUtilCore.isAncestor((VirtualFile)libraryDir, (VirtualFile)file, (boolean)false)) continue;
                            project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                            iterator.remove();
                        }
                    }
                    if (files.isEmpty()) {
                        files = null;
                    }
                }
            }
            dependencies.add(p);
        }
    }

    @Override
    protected void initialize() {
    }

    protected static boolean depsDependsOn(@NonNull Project project, @NonNull String artifact) {
        for (Project dependency : project.getDirectLibraries()) {
            Boolean b = dependency.dependsOn(artifact);
            if (b == null || !b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static class LintGradleLibraryProject
    extends IntellijLintProject {
        private final AndroidLibrary myLibrary;
        private static boolean sOptionalAvailable = true;

        private LintGradleLibraryProject(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidLibrary library) {
            super(client, dir, referenceDir);
            this.myLibrary = library;
            this.mLibrary = true;
            this.mMergeManifests = true;
            this.mReportIssues = false;
            this.mGradleProject = true;
            this.mDirectLibraries = Collections.emptyList();
        }

        @Override
        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifest = this.myLibrary.getManifest();
                this.mManifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        @Override
        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                File proguardRules = this.myLibrary.getProguardRules();
                this.mProguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.mProguardFiles;
        }

        @Override
        @NonNull
        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                File folder = this.myLibrary.getResFolder();
                this.mResourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mResourceFolders;
        }

        @Override
        @NonNull
        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public AndroidProject getGradleProjectModel() {
            return null;
        }

        @Override
        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return this.myLibrary;
        }

        @Override
        @Nullable
        public Boolean dependsOn(@NonNull String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    this.mSupportLib = GradleUtil.dependsOn((AndroidLibrary)this.myLibrary, (String)artifact, (boolean)true);
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = GradleUtil.dependsOn((AndroidLibrary)this.myLibrary, (String)artifact, (boolean)true);
                }
                return this.mAppCompat;
            }
            if (GradleUtil.dependsOn((AndroidLibrary)this.myLibrary, (String)artifact, (boolean)true)) {
                return true;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintGradleProject
    extends LintAndroidModelProject {
        private final AndroidModuleModel myAndroidModuleModel;
        private static boolean sProvidedAvailable = true;

        private LintGradleProject(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidFacet facet, @NonNull AndroidModuleModel AndroidModuleModel2) {
            super(client, dir, referenceDir, facet, (AndroidModel)AndroidModuleModel2);
            this.mGradleProject = true;
            this.mMergeManifests = true;
            this.myAndroidModuleModel = AndroidModuleModel2;
        }

        @Override
        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifestFile;
                SourceProvider variantProvider;
                SourceProvider buildTypeSourceProvider;
                File manifestFile2;
                SourceProvider multiProvider;
                File manifestFile3;
                List flavorSourceProviders;
                this.mManifestFiles = Lists.newArrayList();
                File mainManifest = this.myFacet.getMainSourceProvider().getManifestFile();
                if (mainManifest.exists()) {
                    this.mManifestFiles.add(mainManifest);
                }
                if ((flavorSourceProviders = this.myAndroidModuleModel.getFlavorSourceProviders()) != null) {
                    for (SourceProvider provider : flavorSourceProviders) {
                        manifestFile3 = provider.getManifestFile();
                        if (!manifestFile3.exists()) continue;
                        this.mManifestFiles.add(manifestFile3);
                    }
                }
                if ((multiProvider = this.myAndroidModuleModel.getMultiFlavorSourceProvider()) != null && (manifestFile2 = multiProvider.getManifestFile()).exists()) {
                    this.mManifestFiles.add(manifestFile2);
                }
                if ((buildTypeSourceProvider = this.myAndroidModuleModel.getBuildTypeSourceProvider()) != null && (manifestFile3 = buildTypeSourceProvider.getManifestFile()).exists()) {
                    this.mManifestFiles.add(manifestFile3);
                }
                if ((variantProvider = this.myAndroidModuleModel.getVariantSourceProvider()) != null && (manifestFile = variantProvider.getManifestFile()).exists()) {
                    this.mManifestFiles.add(manifestFile);
                }
            }
            return this.mManifestFiles;
        }

        @Override
        @NonNull
        public List<File> getAssetFolders() {
            if (this.mAssetFolders == null) {
                this.mAssetFolders = Lists.newArrayList();
                for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders((AndroidFacet)this.myFacet)) {
                    Collection dirs = provider.getAssetsDirectories();
                    for (File dir : dirs) {
                        if (!dir.exists()) continue;
                        this.mAssetFolders.add(dir);
                    }
                }
            }
            return this.mAssetFolders;
        }

        @Override
        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                AndroidModuleModel androidModel;
                if (this.myFacet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get((AndroidFacet)this.myFacet)) != null) {
                    ProductFlavor flavor = androidModel.getAndroidProject().getDefaultConfig().getProductFlavor();
                    this.mProguardFiles = Lists.newArrayList();
                    for (File file : flavor.getProguardFiles()) {
                        if (!file.exists()) continue;
                        this.mProguardFiles.add(file);
                    }
                    try {
                        for (File file : flavor.getConsumerProguardFiles()) {
                            if (!file.exists()) continue;
                            this.mProguardFiles.add(file);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.mProguardFiles == null) {
                    this.mProguardFiles = Collections.emptyList();
                }
            }
            return this.mProguardFiles;
        }

        @Override
        @NonNull
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        @Override
        public int getBuildSdk() {
            String compileTarget;
            AndroidVersion version;
            AndroidModuleModel androidModel = AndroidModuleModel.get((AndroidFacet)this.myFacet);
            if (androidModel != null && (version = AndroidTargetHash.getPlatformVersion((String)(compileTarget = androidModel.getAndroidProject().getCompileTarget()))) != null) {
                return version.getFeatureLevel();
            }
            AndroidPlatform platform = AndroidPlatform.getInstance((Module)this.myFacet.getModule());
            if (platform != null) {
                return platform.getApiVersion().getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        @Override
        @Nullable
        public AndroidProject getGradleProjectModel() {
            AndroidModuleModel androidModel = AndroidModuleModel.get((AndroidFacet)this.myFacet);
            if (androidModel != null) {
                return androidModel.getAndroidProject();
            }
            return null;
        }

        @Override
        @Nullable
        public Variant getCurrentVariant() {
            AndroidModuleModel androidModel = AndroidModuleModel.get((AndroidFacet)this.myFacet);
            if (androidModel != null) {
                return androidModel.getSelectedVariant();
            }
            return null;
        }

        @Override
        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return null;
        }

        @Override
        @Nullable
        public Boolean dependsOn(@NonNull String artifact) {
            AndroidModuleModel androidModel = AndroidModuleModel.get((AndroidFacet)this.myFacet);
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    this.mSupportLib = this.myFacet.requiresAndroidModel() && this.myFacet.getAndroidModel() != null ? Boolean.valueOf(GradleUtil.dependsOn((AndroidModuleModel)androidModel, (String)artifact)) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, artifact));
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = this.myFacet.requiresAndroidModel() && this.myFacet.getAndroidModel() != null ? Boolean.valueOf(GradleUtil.dependsOn((AndroidModuleModel)androidModel, (String)artifact)) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, artifact));
                }
                return this.mAppCompat;
            }
            if (this.myFacet.requiresAndroidModel() && this.myFacet.getAndroidModel() != null && GradleUtil.dependsOn((AndroidModuleModel)androidModel, (String)artifact)) {
                return true;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintAndroidModelProject
    extends LintAndroidProject {
        private final AndroidModel myAndroidModel;

        private LintAndroidModelProject(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidFacet facet, @NonNull AndroidModel androidModel) {
            super(client, dir, referenceDir, facet);
            this.myAndroidModel = androidModel;
        }

        @Override
        @Nullable
        public String getPackage() {
            String manifestPackage = super.getPackage();
            if (manifestPackage != null) {
                return manifestPackage;
            }
            return this.myAndroidModel.getApplicationId();
        }

        @Override
        @NonNull
        public AndroidVersion getMinSdkVersion() {
            if (this.mMinSdkVersion == null) {
                this.mMinSdkVersion = AndroidModuleInfo.get((AndroidFacet)this.myFacet).getMinSdkVersion();
            }
            return this.mMinSdkVersion;
        }

        @Override
        @NonNull
        public AndroidVersion getTargetSdkVersion() {
            if (this.mTargetSdkVersion == null) {
                this.mTargetSdkVersion = AndroidModuleInfo.get((AndroidFacet)this.myFacet).getTargetSdkVersion();
            }
            return this.mTargetSdkVersion;
        }
    }

    private static class LintAndroidProject
    extends LintModuleProject {
        protected final AndroidFacet myFacet;

        private LintAndroidProject(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidFacet facet) {
            super(client, dir, referenceDir, facet.getModule());
            this.myFacet = facet;
            this.mGradleProject = false;
            this.mLibrary = this.myFacet.isLibraryProject();
            AndroidPlatform platform = AndroidPlatform.getInstance((Module)this.myFacet.getModule());
            if (platform != null) {
                this.mBuildSdk = platform.getApiLevel();
            }
        }

        @Override
        public boolean isAndroidProject() {
            return true;
        }

        @Override
        @NonNull
        public String getName() {
            return this.myFacet.getModule().getName();
        }

        @Override
        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile((AndroidFacet)this.myFacet);
                this.mManifestFiles = manifestFile != null ? Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile)) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        @Override
        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                List urls;
                JpsAndroidModuleProperties properties = this.myFacet.getProperties();
                if (properties.RUN_PROGUARD && !(urls = properties.myProGuardCfgFiles).isEmpty()) {
                    this.mProguardFiles = new ArrayList();
                    for (String osPath : AndroidUtils.urlsToOsPaths((List)urls, null)) {
                        if (osPath.contains("%MODULE_SDK_HOME%")) continue;
                        this.mProguardFiles.add(new File(osPath));
                    }
                }
                if (this.mProguardFiles == null) {
                    this.mProguardFiles = Collections.emptyList();
                }
            }
            return this.mProguardFiles;
        }

        @Override
        @NonNull
        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                List folders = this.myFacet.getResourceFolderManager().getFolders();
                ArrayList dirs = Lists.newArrayListWithExpectedSize((int)folders.size());
                for (VirtualFile folder : folders) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)folder));
                }
                this.mResourceFolders = dirs;
            }
            return this.mResourceFolders;
        }

        @Override
        @Nullable
        public Boolean dependsOn(@NonNull String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    OrderEntry[] entries = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getOrderEntries();
                    block0: for (int i = entries.length - 1; i >= 0; --i) {
                        LibraryOrderEntry libraryOrderEntry;
                        VirtualFile[] classes2;
                        OrderEntry orderEntry = entries[i];
                        if (!(orderEntry instanceof LibraryOrderEntry) || (classes2 = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES)) == null) continue;
                        for (VirtualFile file : classes2) {
                            if (!file.getName().equals("android-support-v4.jar")) continue;
                            this.mSupportLib = true;
                            break block0;
                        }
                    }
                    if (this.mSupportLib == null) {
                        this.mSupportLib = LintAndroidProject.depsDependsOn(this, artifact);
                    }
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mSupportLib == null) {
                    OrderEntry[] entries = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getOrderEntries();
                    block2: for (int i = entries.length - 1; i >= 0; --i) {
                        LibraryOrderEntry libraryOrderEntry;
                        VirtualFile[] classes3;
                        OrderEntry orderEntry = entries[i];
                        if (!(orderEntry instanceof LibraryOrderEntry) || (classes3 = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES)) == null) continue;
                        for (VirtualFile file : classes3) {
                            if (!file.getName().equals("appcompat-v7.jar")) continue;
                            this.mSupportLib = true;
                            break block2;
                        }
                    }
                    if (this.mSupportLib == null) {
                        this.mSupportLib = LintAndroidProject.depsDependsOn(this, artifact);
                    }
                }
                return this.mSupportLib;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintModuleProject
    extends IntellijLintProject {
        private Module myModule;

        public void setDirectLibraries(List<Project> libraries) {
            this.mDirectLibraries = libraries;
        }

        private LintModuleProject(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir, Module module) {
            super(client, dir, referenceDir);
            this.myModule = module;
        }

        @Override
        public boolean isAndroidProject() {
            return false;
        }

        @Override
        @NonNull
        public List<File> getJavaSourceFolders() {
            if (this.mJavaSourceFolders == null) {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(false);
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                for (VirtualFile root : sourceRoots) {
                    dirs.add(new File(root.getPath()));
                }
                this.mJavaSourceFolders = dirs;
            }
            return this.mJavaSourceFolders;
        }

        @Override
        @NonNull
        public List<File> getTestSourceFolders() {
            if (this.mTestSourceFolders == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.myModule);
                Object[] sourceRoots = manager.getSourceRoots(false);
                VirtualFile[] sourceAndTestRoots = manager.getSourceRoots(true);
                ArrayList<File> dirs = new ArrayList<File>(sourceAndTestRoots.length);
                for (VirtualFile root : sourceAndTestRoots) {
                    if (ArrayUtil.contains((Object)root, (Object[])sourceRoots)) continue;
                    dirs.add(new File(root.getPath()));
                }
                this.mTestSourceFolders = dirs;
            }
            return this.mTestSourceFolders;
        }

        @Override
        @NonNull
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }
    }
}

