/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VisitedModelsDelegateProcessor
implements Processor<SpringBeanPointer> {
    private final Set<CommonSpringModel> visited;
    private final Processor<SpringBeanPointer> myProcessor;

    public VisitedModelsDelegateProcessor(@NotNull Processor<SpringBeanPointer> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/VisitedModelsDelegateProcessor", "<init>"));
        }
        this.visited = ContainerUtil.newTroveSet();
        this.myProcessor = processor;
    }

    public boolean process(SpringBeanPointer pointer) {
        return this.myProcessor.process((Object)pointer);
    }

    public void addVisited(@NotNull CommonSpringModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/VisitedModelsDelegateProcessor", "addVisited"));
        }
        this.visited.add(model);
    }

    public boolean hasBeenVisited(@NotNull CommonSpringModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/VisitedModelsDelegateProcessor", "hasBeenVisited"));
        }
        return this.visited.contains(model);
    }
}

