/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringConstructorArgUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringJavaClassInfo {
    private static final Key<SpringJavaClassInfo> KEY = Key.create((String)"Spring Java Class Info");
    private final PsiClass myPsiClass;
    private final CachedValue<Boolean> myIsMapped;
    private final CachedValue<Set<SpringBeanPointer>> myBeans;
    private final CachedValue<MultiMap<String, SpringPropertyDefinition>> myProperties;
    private final CachedValue<MultiMap<PsiMethod, SpringBeanPointer>> myConstructors;
    private final CachedValue<MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>> myMethods;

    @NotNull
    public static SpringJavaClassInfo getSpringJavaClassInfo(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/java/SpringJavaClassInfo", "getSpringJavaClassInfo"));
        }
        SpringJavaClassInfo info = (SpringJavaClassInfo)psiClass.getUserData(KEY);
        if (info == null) {
            info = new SpringJavaClassInfo(psiClass);
            psiClass.putUserData(KEY, (Object)info);
        }
        SpringJavaClassInfo springJavaClassInfo = info;
        if (springJavaClassInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getSpringJavaClassInfo"));
        }
        return springJavaClassInfo;
    }

    private SpringJavaClassInfo(PsiClass psiClass) {
        this.myPsiClass = psiClass;
        Project project = psiClass.getProject();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myIsMapped = cachedValuesManager.createCachedValue(() -> {
            CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
            boolean exists = SpringModelSearchers.doesBeanExist(model, this.myPsiClass);
            return new CachedValueProvider.Result((Object)exists, this.getDependencies(project, model));
        }, false);
        this.myBeans = cachedValuesManager.createCachedValue(() -> {
            CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
            List<SpringBeanPointer> byInheritance = SpringModelSearchers.findBeans(model, SpringModelSearchParameters.byClass(this.myPsiClass).withInheritors().effectiveBeanTypes());
            return new CachedValueProvider.Result(new LinkedHashSet<SpringBeanPointer>(byInheritance), this.getDependencies(project, model));
        }, false);
        this.myProperties = cachedValuesManager.createCachedValue(() -> {
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            ConcurrentMultiMap map = new ConcurrentMultiMap();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                List<SpringPropertyDefinition> properties = ((SpringBean)bean).getAllProperties();
                for (SpringPropertyDefinition property : properties) {
                    String propertyName = property.getPropertyName();
                    if (propertyName == null) continue;
                    map.putValue((Object)propertyName, (Object)property);
                }
            }
            return new CachedValueProvider.Result((Object)map, new Object[]{DomManager.getDomManager((Project)project)});
        }, false);
        this.myConstructors = cachedValuesManager.createCachedValue(() -> {
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            ConcurrentMultiMap map = new ConcurrentMultiMap();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
                PsiMethod constructor = SpringConstructorArgUtils.getInstance().getSpringBeanConstructor((SpringBean)bean, model);
                if (constructor == null) continue;
                map.putValue((Object)constructor, (Object)beanPointer);
            }
            return new CachedValueProvider.Result((Object)map, new Object[]{DomManager.getDomManager((Project)project)});
        }, false);
        this.myMethods = cachedValuesManager.createCachedValue(() -> {
            SpringBean springBean;
            List<PsiMethod> psiMethods = Arrays.asList(psiClass.getMethods());
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            ConcurrentMultiMap map = new ConcurrentMultiMap();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                Beans beans = (Beans)DomUtil.getParentOfType((DomElement)bean, Beans.class, (boolean)false);
                if (beans != null) {
                    SpringJavaClassInfo.addSpringBeanMethods((MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>)map, psiMethods, SpringMethodType.INIT, beans.getDefaultInitMethod());
                    SpringJavaClassInfo.addSpringBeanMethods((MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>)map, psiMethods, SpringMethodType.DESTROY, beans.getDefaultDestroyMethod());
                }
                springBean = (SpringBean)bean;
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>)map, psiMethods, SpringMethodType.INIT, (GenericAttributeValue<PsiMethod>)springBean.getInitMethod());
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>)map, psiMethods, SpringMethodType.DESTROY, (GenericAttributeValue<PsiMethod>)springBean.getDestroyMethod());
                for (LookupMethod lookupMethod : springBean.getLookupMethods()) {
                    SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>)map, psiMethods, SpringMethodType.LOOKUP, lookupMethod.getName());
                }
            }
            CommonSpringModel springModel = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
            for (SpringBeanPointer pointer : springModel.getAllDomBeans()) {
                PsiMethod factoryMethod;
                GenericAttributeValue<PsiMethod> domFactoryMethod;
                Object commonSpringBean;
                if (!pointer.isValid() || !((commonSpringBean = pointer.getSpringBean()) instanceof SpringBean) || !commonSpringBean.isValid() || !DomUtil.hasXml(domFactoryMethod = (springBean = (SpringBean)commonSpringBean).getFactoryMethod()) || (factoryMethod = (PsiMethod)domFactoryMethod.getValue()) == null || !psiMethods.contains(factoryMethod)) continue;
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>>)map, psiMethods, SpringMethodType.FACTORY, domFactoryMethod);
            }
            return new CachedValueProvider.Result((Object)map, new Object[]{DomManager.getDomManager((Project)project), this.myPsiClass});
        }, false);
    }

    @NotNull
    private Object[] getDependencies(@NotNull Project project, @NotNull CommonSpringModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/java/SpringJavaClassInfo", "getDependencies"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/java/SpringJavaClassInfo", "getDependencies"));
        }
        LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addIfNotNull((Collection)dependencies, (Object)this.myPsiClass.getContainingFile());
        ContainerUtil.addAll((Collection)dependencies, (Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies());
        dependencies.addAll(model.getConfigFiles());
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)dependencies);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getDependencies"));
        }
        return objectArray;
    }

    private static void addSpringBeanMethod(@NotNull MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>> map, @NotNull List<PsiMethod> psiMethods, @NotNull SpringMethodType type, @NotNull GenericAttributeValue<PsiMethod> genericAttributeValue) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethod"));
        }
        if (psiMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethods", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethod"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethod"));
        }
        if (genericAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericAttributeValue", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethod"));
        }
        if (!DomUtil.hasXml(genericAttributeValue)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)genericAttributeValue.getValue();
        if (psiMethod != null && psiMethods.contains(psiMethod)) {
            map.putValue((Object)psiMethod, (Object)Pair.create(genericAttributeValue, (Object)((Object)type)));
        }
    }

    private static void addSpringBeanMethods(@NotNull MultiMap<PsiMethod, Pair<DomElement, SpringMethodType>> map, @NotNull List<PsiMethod> psiMethods, @NotNull SpringMethodType type, @NotNull GenericAttributeValue<Set<PsiMethod>> genericAttributeValue) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethods"));
        }
        if (psiMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethods", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethods"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethods"));
        }
        if (genericAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericAttributeValue", "com/intellij/spring/java/SpringJavaClassInfo", "addSpringBeanMethods"));
        }
        if (!DomUtil.hasXml(genericAttributeValue)) {
            return;
        }
        Set methods = (Set)genericAttributeValue.getValue();
        if (methods != null) {
            for (PsiMethod psiMethod : methods) {
                if (!psiMethods.contains(psiMethod)) continue;
                map.putValue((Object)psiMethod, (Object)Pair.create(genericAttributeValue, (Object)((Object)type)));
            }
        }
    }

    public boolean isMapped() {
        return (Boolean)this.myIsMapped.getValue();
    }

    public boolean isMappedDomBean() {
        return this.isMapped() && ContainerUtil.findInstance((Iterable)((Iterable)this.myBeans.getValue()), DomSpringBeanPointer.class) != null;
    }

    @NotNull
    public List<DomSpringBeanPointer> getMappedDomBeans() {
        List list = !this.isMapped() ? Collections.emptyList() : ContainerUtil.findAll((Collection)((Collection)this.myBeans.getValue()), DomSpringBeanPointer.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMappedDomBeans"));
        }
        return list;
    }

    public boolean isStereotypeJavaBean() {
        return this.isMapped() && ContainerUtil.findInstance((Iterable)((Iterable)this.myBeans.getValue()), JamSpringBeanPointer.class) != null;
    }

    @NotNull
    public List<JamSpringBeanPointer> getStereotypeMappedBeans() {
        List list = !this.isMapped() ? Collections.emptyList() : ContainerUtil.findAll((Collection)((Collection)this.myBeans.getValue()), JamSpringBeanPointer.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getStereotypeMappedBeans"));
        }
        return list;
    }

    public boolean isAutowired() {
        List<DomSpringBeanPointer> pointers = this.getMappedDomBeans();
        for (DomSpringBeanPointer pointer : pointers) {
            Autowire autowire;
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || !(autowire = ((SpringBean)springBean).getBeanAutowire()).isAutowired()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<Autowire> getAutowires() {
        EnumSet<Autowire> autowires = EnumSet.noneOf(Autowire.class);
        for (DomSpringBeanPointer pointer : this.getMappedDomBeans()) {
            Autowire autowire;
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || !(autowire = ((SpringBean)springBean).getBeanAutowire()).isAutowired()) continue;
            autowires.add(autowire);
        }
        EnumSet<Autowire> enumSet = autowires;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getAutowires"));
        }
        return enumSet;
    }

    @NotNull
    public Collection<SpringPropertyDefinition> getMappedProperties(String propertyName) {
        MultiMap value = (MultiMap)this.myProperties.getValue();
        if (value == null) {
            List<SpringPropertyDefinition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMappedProperties"));
            }
            return list;
        }
        Collection collection = value.get((Object)propertyName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMappedProperties"));
        }
        return collection;
    }

    @NotNull
    public Collection<SpringBeanPointer> getMappedConstructorDefinitions(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/java/SpringJavaClassInfo", "getMappedConstructorDefinitions"));
        }
        MultiMap value = (MultiMap)this.myConstructors.getValue();
        if (value == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMappedConstructorDefinitions"));
            }
            return list;
        }
        Collection collection = value.get((Object)psiMethod);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMappedConstructorDefinitions"));
        }
        return collection;
    }

    @NotNull
    public Collection<Pair<DomElement, SpringMethodType>> getMethodTypes(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/java/SpringJavaClassInfo", "getMethodTypes"));
        }
        MultiMap value = (MultiMap)this.myMethods.getValue();
        if (value == null) {
            List<Pair<DomElement, SpringMethodType>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMethodTypes"));
            }
            return list;
        }
        Collection collection = value.get((Object)psiMethod);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/java/SpringJavaClassInfo", "getMethodTypes"));
        }
        return collection;
    }

    public boolean isMappedProperty(PsiMethod method) {
        String propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)method);
        return !this.getMappedProperties(propertyName).isEmpty();
    }

    public boolean isMappedConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/java/SpringJavaClassInfo", "isMappedConstructor"));
        }
        if (!method.isConstructor()) {
            return false;
        }
        return ((MultiMap)this.myConstructors.getValue()).containsKey((Object)method);
    }

    public static enum SpringMethodType {
        INIT("init"),
        DESTROY("destroy"),
        FACTORY("factory"),
        LOOKUP("lookup");

        private final String myName;

        private SpringMethodType(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }
}

