/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.aliasFor;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAliasForUtils {
    @Nullable
    public static SpringAliasFor findAliasFor(@NotNull PsiElement context, @Nullable String toSearchInAnnotation, @NotNull String aliasedClassName, @NotNull String attrName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (aliasedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasedClassName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        return SpringAliasForUtils.getAliasFor(context.getProject(), context.getResolveScope(), toSearchInAnnotation, aliasedClassName, attrName);
    }

    @Nullable
    public static SpringAliasFor findAliasFor(@NotNull Project project, @Nullable String toSearchInAnnotation, @NotNull String aliasedClassName, @NotNull String attrName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (aliasedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasedClassName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findAliasFor"));
        }
        return SpringAliasForUtils.getAliasFor(project, GlobalSearchScope.allScope((Project)project), toSearchInAnnotation, aliasedClassName, attrName);
    }

    protected static SpringAliasFor getAliasFor(@NotNull Project project, @NotNull GlobalSearchScope scope, @Nullable String toSearchInAnnotation, @NotNull String aliasedClassName, @NotNull String attrName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasFor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasFor"));
        }
        if (aliasedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasedClassName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasFor"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasFor"));
        }
        if (toSearchInAnnotation == null) {
            return null;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass toSearchInClass = javaPsiFacade.findClass(toSearchInAnnotation, scope);
        if (toSearchInClass == null || !toSearchInClass.isAnnotationType()) {
            return null;
        }
        PsiClass annotationClass = javaPsiFacade.findClass(aliasedClassName, scope);
        if (annotationClass == null || !annotationClass.isAnnotationType()) {
            return null;
        }
        for (SpringAliasFor aliasFor : SpringAliasForUtils.getAliasForAttributes(toSearchInClass)) {
            if (!attrName.equals(aliasFor.getAttributeName()) || !annotationClass.equals(aliasFor.getAnnotationClass())) continue;
            return aliasFor;
        }
        return null;
    }

    @NotNull
    private static List<SpringAliasFor> getAliasForAttributes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasForAttributes"));
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "lambda$getAliasForAttributes$0"));
            }
            List aliasForList = JamService.getJamService((Project)psiClass.getProject()).getAnnotatedMembersList(psiClass, SpringAliasFor.SEM_KEY, false, true, false, false);
            return CachedValueProvider.Result.create((Object)aliasForList, (Object[])new Object[]{psiClass});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAliasForAttributes"));
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findDefiningMetaAnnotation(@NotNull PsiElement context, @NotNull String customAnnotationFqn, @NotNull String baseMetaAnnotationFqn) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (customAnnotationFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customAnnotationFqn", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (baseMetaAnnotationFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMetaAnnotationFqn", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return null;
        }
        PsiClass customAnnoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(customAnnotationFqn, context.getResolveScope());
        return SpringAliasForUtils.findDefiningMetaAnnotation(customAnnoClass, baseMetaAnnotationFqn, JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren(baseMetaAnnotationFqn));
    }

    @Nullable
    public static PsiAnnotation findDefiningMetaAnnotation(@Nullable PsiClass customAnnoClass, @NotNull String baseMetaAnnotationFqn, @NotNull Collection<PsiClass> allMetaAnnotations) {
        if (baseMetaAnnotationFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMetaAnnotationFqn", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (allMetaAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allMetaAnnotations", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "findDefiningMetaAnnotation"));
        }
        if (customAnnoClass == null || !customAnnoClass.isAnnotationType()) {
            return null;
        }
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)customAnnoClass, (boolean)true, (String[])new String[]{baseMetaAnnotationFqn});
        if (psiAnnotation != null) {
            return psiAnnotation;
        }
        for (PsiClass customMetaAnnoClass : allMetaAnnotations) {
            String qualifiedName = customMetaAnnoClass.getQualifiedName();
            if (qualifiedName == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)customAnnoClass, (String)qualifiedName, (boolean)true)) continue;
            return SpringAliasForUtils.findDefiningMetaAnnotation(customMetaAnnoClass, baseMetaAnnotationFqn, allMetaAnnotations);
        }
        return null;
    }

    public static NotNullFunction<Pair<String, Project>, JamAnnotationMeta> getAnnotationMetaProducer(@NotNull SemKey<JamAnnotationMeta> annoMetaKey, JamMemberMeta<?, ?> ... parentMetas) {
        if (annoMetaKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoMetaKey", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAnnotationMetaProducer"));
        }
        if (parentMetas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentMetas", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "getAnnotationMetaProducer"));
        }
        return anno -> {
            if (annoMetaKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoMetaKey", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "lambda$getAnnotationMetaProducer$1"));
            }
            if (parentMetas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentMetas", "com/intellij/spring/model/aliasFor/SpringAliasForUtils", "lambda$getAnnotationMetaProducer$1"));
            }
            return new JamAnnotationMeta((String)anno.first, null, (SemKey)annoMetaKey, (JamMemberMeta[])parentMetas, (Pair)anno){
                final /* synthetic */ JamMemberMeta[] val$parentMetas;
                final /* synthetic */ Pair val$anno;
                {
                    this.val$parentMetas = jamMemberMetaArray;
                    this.val$anno = pair;
                    super(arg0, arg1, arg2);
                }

                @Nullable
                public JamAttributeMeta<?> findAttribute(@Nullable @NonNls String name) {
                    JamAttributeMeta attribute = super.findAttribute(name);
                    if (attribute != null) {
                        return attribute;
                    }
                    if (name == null) {
                        name = "value";
                    }
                    return this.getAliasedAttributeMeta(name);
                }

                @Nullable
                private JamAttributeMeta<?> getAliasedAttributeMeta(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/aliasFor/SpringAliasForUtils$1", "getAliasedAttributeMeta"));
                    }
                    for (JamMemberMeta parentMeta : this.val$parentMetas) {
                        for (JamAnnotationMeta annotationMeta : parentMeta.getAnnotations()) {
                            List<JamAttributeMeta<?>> parentAnnotationAttributes = this.getRegisteredAttributes(annotationMeta);
                            for (JamAttributeMeta<?> attributeMeta : parentAnnotationAttributes) {
                                String aliasForMethodName;
                                if (!(attributeMeta instanceof JamStringAttributeMeta)) continue;
                                JamStringAttributeMeta meta = (JamStringAttributeMeta)attributeMeta;
                                JamConverter converter = meta.getConverter();
                                SpringAliasFor aliasFor = SpringAliasForUtils.findAliasFor((Project)this.val$anno.second, (String)this.val$anno.first, annotationMeta.getAnnoName(), meta.getAttributeLink().getAttributeName());
                                if (aliasFor == null || !name.equals(aliasForMethodName = aliasFor.getMethodName())) continue;
                                if (attributeMeta instanceof JamStringAttributeMeta.Single) {
                                    return JamAttributeMeta.singleString((String)aliasForMethodName, (JamConverter)converter);
                                }
                                if (!(attributeMeta instanceof JamStringAttributeMeta.Collection)) continue;
                                return JamAttributeMeta.collectionString((String)aliasForMethodName, (JamConverter)converter);
                            }
                        }
                    }
                    return null;
                }

                private List<JamAttributeMeta<?>> getRegisteredAttributes(@NotNull JamAnnotationMeta annotationMeta) {
                    if (annotationMeta == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationMeta", "com/intellij/spring/model/aliasFor/SpringAliasForUtils$1", "getRegisteredAttributes"));
                    }
                    List attributeMetas = ContainerUtil.newSmartList();
                    attributeMetas.addAll(annotationMeta.getAttributes());
                    JamAnnotationArchetype archetype = annotationMeta.getArchetype();
                    if (archetype != null) {
                        attributeMetas.addAll(archetype.getAttributes());
                    }
                    return attributeMetas;
                }
            };
        };
    }
}

