/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamPsiMemberSpringBean<T extends PsiMember>
extends CommonModelElement.PsiBase
implements JamElement,
CommonSpringBean {
    public static final SemKey<JamPsiMemberSpringBean> PSI_MEMBER_SPRING_BEAN_JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("PsiMemberSpringBean", new SemKey[0]);

    @JamPsiConnector
    @NotNull
    public abstract T getPsiElement();

    @JamPsiValidity
    public abstract boolean isValid();

    @Override
    @Nullable
    public PsiType getBeanType(boolean considerFactories) {
        return this.getBeanType();
    }

    @Override
    @NotNull
    public String[] getAliases() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/JamPsiMemberSpringBean", "getAliases"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected List<String> getStringNames(List<JamStringAttributeElement<String>> elements) {
        SmartList aliases = new SmartList();
        for (JamStringAttributeElement<String> element : elements) {
            String aliasName = element.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            aliases.add(aliasName);
        }
        return aliases;
    }

    @Override
    public SpringQualifier getSpringQualifier() {
        SpringJamQualifier jamQualifier = this.getQualifier();
        return jamQualifier == null ? DefaultSpringBeanQualifier.create(this) : jamQualifier;
    }

    @Nullable
    public SpringJamQualifier getQualifier() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        return SpringJamQualifier.findSpringJamQualifier(module, this.getPsiElement());
    }

    @Override
    public boolean isPrimary() {
        return AnnotationUtil.isAnnotated(this.getPsiElement(), (String)"org.springframework.context.annotation.Primary", (boolean)false);
    }

    @Override
    @NotNull
    public SpringProfile getProfile() {
        T psiElement = this.getPsiElement();
        SpringContextProfile springProfile = this.getProfile((PsiMember)psiElement);
        if (springProfile == null) {
            springProfile = this.getProfile((PsiMember)psiElement.getContainingClass());
        }
        SpringProfile springProfile2 = springProfile != null ? springProfile : SpringProfile.DEFAULT;
        if (springProfile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/JamPsiMemberSpringBean", "getProfile"));
        }
        return springProfile2;
    }

    @Nullable
    public SpringContextProfile getProfile(@Nullable PsiMember psiElement) {
        return psiElement == null ? null : (SpringContextProfile)JamService.getJamService((Project)this.getPsiManager().getProject()).getJamElement(SpringContextProfile.CONTEXT_PROFILE_JAM_KEY, (PsiElement)psiElement);
    }
}

