/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringSchemaVersion;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCommonUtils {
    public static final String SPRING_DELIMITERS = ",; ";
    public static final CharFilter ourFilter = ch -> SPRING_DELIMITERS.indexOf(ch) >= 0;

    private SpringCommonUtils() {
    }

    public static List<String> tokenize(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/spring/model/utils/SpringCommonUtils", "tokenize"));
        }
        SmartList list = new SmartList();
        StringTokenizer st = new StringTokenizer(str, SPRING_DELIMITERS);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) continue;
            list.add(token);
        }
        return list;
    }

    @NotNull
    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            SmartList generics = new SmartList();
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
            SmartList smartList = generics;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringCommonUtils", "resolveGenerics"));
            }
            return smartList;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringCommonUtils", "resolveGenerics"));
        }
        return list;
    }

    public static boolean hasSpringFacets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/SpringCommonUtils", "hasSpringFacets"));
        }
        return ProjectFacetManager.getInstance((Project)project).hasFacets(SpringFacet.FACET_TYPE_ID);
    }

    public static boolean hasSpringFacet(@Nullable Module module) {
        return module != null && SpringFacet.getInstance(module) != null;
    }

    public static boolean isConfiguration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/utils/SpringCommonUtils", "isConfiguration"));
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.context.annotation.Configuration", (boolean)false);
    }

    public static boolean isConfigurationOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/utils/SpringCommonUtils", "isConfigurationOrMeta"));
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null;
    }

    public static boolean isStereotypeComponentOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/utils/SpringCommonUtils", "isStereotypeComponentOrMeta"));
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    public static boolean isSpringBeanCandidateClass(@Nullable PsiClass psiClass) {
        return psiClass != null && !(psiClass instanceof PsiTypeParameter) && !psiClass.hasModifierProperty("private") && !psiClass.isAnnotationType() && psiClass.getQualifiedName() != null && !PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass);
    }

    public static PsiElement createSpringXmlConfigFile(String newName, PsiDirectory directory) throws Exception {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        FileTemplate template = SpringCommonUtils.getSpringXmlTemplate(module);
        String fileName = FileUtilRt.getExtension((String)newName).length() == 0 ? newName + ".xml" : newName;
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, null, (PsiDirectory)directory);
    }

    public static FileTemplate getSpringXmlTemplate(Module ... modules) {
        for (Module module : modules) {
            String version = JarVersionDetectionUtil.detectJarVersion((String)"org.springframework.core.SpringVersion", (Module)module);
            if (version == null) continue;
            return version.startsWith("1") ? SpringSchemaVersion.SPRING_1_DTD.getTemplate(module.getProject()) : SpringSchemaVersion.SPRING_SCHEMA.getTemplate(module.getProject());
        }
        return SpringSchemaVersion.SPRING_SCHEMA.getTemplate(modules[0].getProject());
    }

    @Contract(value="null -> false")
    public static boolean isSpringConfigured(@Nullable Module module) {
        if (module != null) {
            if (SpringCommonUtils.hasSpringFacet(module)) {
                return true;
            }
            for (Module dependent : ModuleUtilCore.getAllDependentModules((Module)module)) {
                if (!SpringCommonUtils.hasSpringFacet(dependent)) continue;
                return true;
            }
            HashSet dependencies = ContainerUtil.newHashSet();
            ModuleUtilCore.getDependencies((Module)module, (Set)dependencies);
            for (Module dependency : dependencies) {
                if (!SpringCommonUtils.hasSpringFacet(dependency)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null->false")
    public static boolean isSpringBeanCandidateClassInSpringProject(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (!SpringCommonUtils.hasSpringFacets(psiClass.getProject())) {
            return false;
        }
        if (!SpringLibraryUtil.hasSpringLibrary(psiClass.getProject())) {
            return false;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null && SpringCommonUtils.isSpringConfigured(module)) {
            return true;
        }
        return module == null;
    }

    public static <T extends PsiFile> List<T> findConfigFilesInMetaInf(Module module, boolean withTests, String filename, Class<T> psiFileType) {
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)withTests);
        return SpringCommonUtils.findConfigFilesInMetaInf(module.getProject(), moduleScope, filename, psiFileType);
    }

    @NotNull
    public static <T extends PsiFile> List<T> findConfigFilesInMetaInf(Project project, GlobalSearchScope scope, String filename, Class<T> psiFileType) {
        PsiPackage metaInfPackage = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metaInfPackage == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringCommonUtils", "findConfigFilesInMetaInf"));
            }
            return list;
        }
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)metaInfPackage, (boolean)false);
        GlobalSearchScope searchScope = scope.intersectWith(packageScope);
        Object[] configFiles = FilenameIndex.getFilesByName((Project)project, (String)filename, (GlobalSearchScope)searchScope);
        if (configFiles.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringCommonUtils", "findConfigFilesInMetaInf"));
            }
            return list;
        }
        List list = ContainerUtil.findAll((Object[])configFiles, psiFileType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringCommonUtils", "findConfigFilesInMetaInf"));
        }
        return list;
    }

    public static PsiClass findLibraryClass(final @Nullable Module module, @NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/spring/model/utils/SpringCommonUtils", "findLibraryClass"));
        }
        if (module == null || module.isDisposed()) {
            return null;
        }
        final Project project = module.getProject();
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentFactoryMap<String, PsiClass> map = new ConcurrentFactoryMap<String, PsiClass>(){

                @Nullable
                protected PsiClass create(String key) {
                    GlobalSearchScope searchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
                    return JavaPsiFacade.getInstance((Project)project).findClass(key, searchScope);
                }
            };
            return CachedValueProvider.Result.createSingleDependency((Object)map, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        return (PsiClass)cache.get(className);
    }
}

