/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.resources;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.Function;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringResourcesBuilder {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final String myText;
    private boolean myFromRoot;
    private boolean myFromCurrent;
    private int myOffset;
    private boolean mySoft;
    @NotNull
    private Condition<PsiFileSystemItem> myFilter;
    private boolean myEndingSlashNotAllowed;
    @Nullable
    private Function<PsiFile, Collection<PsiFileSystemItem>> myCustomDefaultPathEvaluator;
    @NotNull
    private Module[] myModules;
    @Nullable
    private String myTemplateName;

    private SpringResourcesBuilder(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "<init>"));
        }
        this(element, text, ElementManipulators.getOffsetInElement((PsiElement)element));
    }

    private SpringResourcesBuilder(@NotNull PsiElement element, @NotNull String text, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "<init>"));
        }
        this.myFromRoot = false;
        this.myFromCurrent = false;
        this.myOffset = 0;
        this.mySoft = true;
        this.myFilter = Conditions.alwaysTrue();
        this.myEndingSlashNotAllowed = true;
        this.myCustomDefaultPathEvaluator = null;
        this.myModules = Module.EMPTY_ARRAY;
        this.myElement = element;
        this.myText = text;
        this.myOffset = offset;
    }

    public static SpringResourcesBuilder create(@NotNull PsiElement element, @NotNull String s) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "create"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "create"));
        }
        return new SpringResourcesBuilder(element, s);
    }

    public static SpringResourcesBuilder create(@NotNull PsiElement element, @NotNull String s, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "create"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "create"));
        }
        return new SpringResourcesBuilder(element, s, offset);
    }

    public SpringResourcesBuilder fromRoot(boolean fromRoot) {
        this.myFromRoot = fromRoot;
        return this;
    }

    public SpringResourcesBuilder fromCurrent(boolean fromCurrent) {
        this.myFromCurrent = fromCurrent;
        return this;
    }

    public SpringResourcesBuilder offset(int offset) {
        this.myOffset = offset;
        return this;
    }

    public SpringResourcesBuilder soft(boolean soft) {
        this.mySoft = soft;
        return this;
    }

    public SpringResourcesBuilder endingSlashNotAllowed(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        return this;
    }

    public SpringResourcesBuilder filter(@NotNull Condition<PsiFileSystemItem> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "filter"));
        }
        this.myFilter = filter;
        return this;
    }

    public SpringResourcesBuilder customDefaultPathEvaluator(@Nullable Function<PsiFile, Collection<PsiFileSystemItem>> customDefaultPathEvaluator) {
        this.myCustomDefaultPathEvaluator = customDefaultPathEvaluator;
        return this;
    }

    public SpringResourcesBuilder modules(Module ... modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "modules"));
        }
        this.myModules = modules;
        return this;
    }

    public SpringResourcesBuilder newFileTemplateName(String templateName) {
        this.myTemplateName = templateName;
        return this;
    }

    @NotNull
    PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "getElement"));
        }
        return psiElement;
    }

    @NotNull
    String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "getText"));
        }
        return string;
    }

    boolean isFromRoot() {
        return this.myFromRoot;
    }

    boolean isFromCurrent() {
        return this.myFromCurrent;
    }

    int getOffset() {
        return this.myOffset;
    }

    boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    Condition<PsiFileSystemItem> getFilter() {
        Condition<PsiFileSystemItem> condition = this.myFilter;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "getFilter"));
        }
        return condition;
    }

    boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    @Nullable
    Function<PsiFile, Collection<PsiFileSystemItem>> getCustomDefaultPathEvaluator() {
        return this.myCustomDefaultPathEvaluator;
    }

    @NotNull
    Module[] getModules() {
        if (this.myModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesBuilder", "getModules"));
        }
        return this.myModules;
    }

    @Nullable
    String getTemplateName() {
        return this.myTemplateName;
    }
}

