/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.IncorrectOperationException;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringProfile
extends RenameableFakePsiElement {
    private String myProfileName;

    public SpringProfile(@NotNull String profileName, PsiElement definition) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/spring/profiles/SpringProfile", "<init>"));
        }
        super(definition);
        this.myProfileName = profileName;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.getParent();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/profiles/SpringProfile", "getNavigationElement"));
        }
        return psiElement;
    }

    @NotNull
    public String getName() {
        String string = this.myProfileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/profiles/SpringProfile", "getName"));
        }
        return string;
    }

    public String getTypeName() {
        return SpringApiBundle.message("profile.type.name", new Object[0]);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/profiles/SpringProfile", "setName"));
        }
        PsiElement res = super.setName(name);
        this.myProfileName = name;
        return res;
    }

    public Icon getIcon() {
        return SpringApiIcons.SpringProfile;
    }
}

