/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.actions;

import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.agent.WebLogicAgentExtension;
import com.intellij.javaee.weblogic.dataSource.WeblogicDataSourceInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class WeblogicCreateDatasourceDialog
extends DialogWrapper {
    private final WebLogicAgentExtension myAgentExtension;
    private final String myDSName;
    private JTextField myJndiName;
    private JCheckBox myRowPrefetchEnabled;
    private JTextField myRowPrefetchSize;
    private JTextField myStreamChunkSize;
    private JTextField myNotes;

    protected WeblogicCreateDatasourceDialog(Project project, WebLogicAgentExtension agentExtension, String dsName) {
        super(project, false);
        this.myAgentExtension = agentExtension;
        this.myDSName = dsName;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(WeblogicBundle.message("label.create.datasource.specify.configuration.parameters", this.myDSName)), "North");
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints gb = new GridBagConstraints();
        panel.setLayout(new GridBagLayout());
        gb.fill = 1;
        gb.anchor = 18;
        gb.gridy = -1;
        gb.gridx = 0;
        gb.insets = new Insets(4, 8, 4, 8);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        JLabel label = new JLabel(WeblogicBundle.message("label.create.datasource.name", new Object[0]));
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        JTextField name = new JTextField(this.myDSName);
        name.setEditable(false);
        label.setLabelFor(name);
        panel.add((Component)name, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        label = new JLabel(WeblogicBundle.message("label.create.datasource.jndi.name", new Object[0]));
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.myJndiName = new JTextField(this.myDSName);
        label.setLabelFor(this.myJndiName);
        panel.add((Component)this.myJndiName, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 0;
        gb.weightx = 0.0;
        panel.add((Component)this.createConnectionSettingsPanel(), gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        label = new JLabel(WeblogicBundle.message("label.create.datasource.deployment.order", new Object[0]));
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        JTextField deploymentOrder = new JTextField("1000");
        label.setLabelFor(deploymentOrder);
        panel.add((Component)deploymentOrder, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.myRowPrefetchEnabled = new JCheckBox(WeblogicBundle.message("checkbox.create.datasource.row.prefetch.enabled", new Object[0]), false);
        panel.add((Component)this.myRowPrefetchEnabled, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        label = new JLabel(WeblogicBundle.message("label.create.datasource.row.prefetch.size", new Object[0]));
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.myRowPrefetchSize = new JTextField("48");
        label.setLabelFor(this.myRowPrefetchSize);
        panel.add((Component)this.myRowPrefetchSize, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        label = new JLabel(WeblogicBundle.message("label.create.datasource.stream.chunk.size", new Object[0]));
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.myStreamChunkSize = new JTextField("256");
        label.setLabelFor(this.myStreamChunkSize);
        panel.add((Component)this.myStreamChunkSize, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        label = new JLabel(WeblogicBundle.message("label.create.datasource.notes", new Object[0]));
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.myNotes = new JTextField();
        label.setLabelFor(this.myNotes);
        panel.add((Component)this.myNotes, gb);
        JPanel dataSourceTypeHolder = this.createDataSourceTypeHolder();
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        panel.add((Component)dataSourceTypeHolder, gb);
        return panel;
    }

    protected abstract JPanel createConnectionSettingsPanel();

    protected abstract JPanel createDataSourceTypeHolder();

    protected void enableElements(Component[] components, boolean enable) {
        for (Component component : components) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            this.enableElements(((Container)component).getComponents(), enable);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJndiName;
    }

    protected WebLogicAgentExtension getAgentExtension() {
        return this.myAgentExtension;
    }

    public static int parseInt(String s) throws Exception {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new Exception(WeblogicBundle.message("error.create.datasource.integer.expected", s));
        }
    }

    protected WeblogicDataSourceInfoImpl getDataSourceInfo() throws Exception {
        WeblogicDataSourceInfoImpl info = new WeblogicDataSourceInfoImpl();
        info.setDSName(this.myDSName);
        info.setJNDIName(this.myJndiName.getText());
        info.setRowPrefetchEnabled(this.myRowPrefetchEnabled.isSelected());
        info.setRowPrefetchSize(WeblogicCreateDatasourceDialog.parseInt(this.myRowPrefetchSize.getText()));
        info.setStreamChunkSize(WeblogicCreateDatasourceDialog.parseInt(this.myStreamChunkSize.getText()));
        info.setNotes(this.myNotes.getText());
        return info;
    }

    public static Properties parseProperties(String source) {
        StringTokenizer tokenizer = new StringTokenizer(source, ";");
        Properties properties = new Properties();
        while (tokenizer.hasMoreTokens()) {
            String value;
            String key;
            String s = tokenizer.nextToken().trim();
            int i = s.indexOf("=");
            if (i == -1) {
                key = s;
                value = "";
            } else {
                key = s.substring(0, i);
                value = s.substring(i + 1);
            }
            properties.put(key, value);
        }
        return properties;
    }
}

