/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facelets.providers;

import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FaceletsUiDefineReferenceProvider
extends JsfXmlAttributeReferencesProvider {
    private static String ATTRIBUTE_NAME = "name";
    public static String DEFINE_TAG_NAME = "define";
    public static String COMPOSITION_TAG_NAME = "composition";
    private static final Key<CachedValue<Map<String, PsiElement>>> TEMPLATE_INSERT_CACHE = Key.create((String)"TEMPLATE_INSERT_CACHE");
    public static String INSERT_TAG_NAME = "insert";

    @Override
    public ElementFilter getElementFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter(DEFINE_TAG_NAME)), (ElementFilter)new NamespaceFilter(XmlUtil.FACELETS_URIS)), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ATTRIBUTE_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider", "createReferences"));
        }
        return new PsiReference[]{new UiDefinePsiReference(xmlAttributeValue)};
    }

    @NotNull
    private static MultiMap<String, PsiElement> getTemplateInserts(@NotNull XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider", "getTemplateInserts"));
        }
        MultiMap map = new MultiMap();
        XmlTag uiCompositionTag = FaceletsUiDefineReferenceProvider.getUiCompositionTag(xmlAttributeValue);
        if (uiCompositionTag != null) {
            Set<XmlFile> templateFiles = FaceletsUiDefineReferenceProvider.getTemplateFiles(uiCompositionTag);
            for (final XmlFile templateFile : templateFiles) {
                CachedValue mapCachedValue = (CachedValue)templateFile.getUserData(TEMPLATE_INSERT_CACHE);
                if (mapCachedValue == null) {
                    mapCachedValue = CachedValuesManager.getManager((Project)templateFile.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiElement>>(){

                        public CachedValueProvider.Result<Map<String, PsiElement>> compute() {
                            final HashMap templateDefinesMap = new HashMap();
                            templateFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                                public void visitXmlTag(XmlTag tag) {
                                    String name;
                                    XmlAttribute attribute;
                                    PsiFile psiFile = tag.getContainingFile();
                                    if (psiFile instanceof DummyHolderElement) {
                                        return;
                                    }
                                    super.visitXmlTag(tag);
                                    if (INSERT_TAG_NAME.equals(tag.getLocalName()) && Arrays.asList(XmlUtil.FACELETS_URIS).contains(tag.getNamespace()) && (attribute = tag.getAttribute(ATTRIBUTE_NAME)) != null && attribute.getValueElement() != null && !StringUtil.isEmptyOrSpaces((String)(name = tag.getAttributeValue(ATTRIBUTE_NAME)))) {
                                        templateDefinesMap.put(name, attribute.getValueElement());
                                    }
                                }
                            });
                            return CachedValueProvider.Result.create(templateDefinesMap, (Object[])new Object[]{templateFile});
                        }
                    }, false);
                    templateFile.putUserData(TEMPLATE_INSERT_CACHE, (Object)mapCachedValue);
                }
                for (Map.Entry entry : ((Map)mapCachedValue.getValue()).entrySet()) {
                    map.putValue(entry.getKey(), entry.getValue());
                }
            }
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider", "getTemplateInserts"));
        }
        return multiMap;
    }

    @NotNull
    private static Set<XmlFile> getTemplateFiles(@NotNull XmlTag uiCompositionTag) {
        XmlAttributeValue valueElement;
        if (uiCompositionTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiCompositionTag", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider", "getTemplateFiles"));
        }
        HashSet files = new HashSet();
        XmlAttribute value = uiCompositionTag.getAttribute("template");
        if (value != null && (valueElement = value.getValueElement()) != null) {
            PsiReference[] references = valueElement.getReferences();
            for (int i = references.length - 1; i >= 0; --i) {
                ResolveResult[] results;
                PsiReference ref = references[i];
                if (!(ref instanceof PsiPolyVariantReference)) continue;
                for (ResolveResult result : results = ((PsiPolyVariantReference)ref).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (!(element instanceof XmlFile)) continue;
                    files.add((XmlFile)element);
                }
                break;
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider", "getTemplateFiles"));
        }
        return hashSet;
    }

    @Nullable
    private static XmlTag getUiCompositionTag(@NotNull XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider", "getUiCompositionTag"));
        }
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlTag.class);
        while (parent != null) {
            if (COMPOSITION_TAG_NAME.equals(parent.getLocalName()) && Arrays.asList(XmlUtil.FACELETS_URIS).contains(parent.getNamespace())) {
                return parent;
            }
            parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parent, XmlTag.class);
        }
        return null;
    }

    private static class UiDefinePsiReference
    extends PsiReferenceBase.Poly<PsiElement>
    implements PsiPolyVariantReference {
        private final XmlAttributeValue myXmlAttributeValue;

        public UiDefinePsiReference(XmlAttributeValue xmlAttributeValue) {
            super((PsiElement)xmlAttributeValue);
            this.myXmlAttributeValue = xmlAttributeValue;
        }

        @NotNull
        public Object[] getVariants() {
            Set templateInserts = FaceletsUiDefineReferenceProvider.getTemplateInserts((XmlAttributeValue)this.getElement()).keySet();
            Object[] objectArray = ArrayUtil.toStringArray((Collection)templateInserts);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider$UiDefinePsiReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            String value = this.getValue();
            if (StringUtil.isEmptyOrSpaces((String)value)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider$UiDefinePsiReference", "multiResolve"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            HashSet resolved = new HashSet();
            for (PsiElement psiElement : FaceletsUiDefineReferenceProvider.getTemplateInserts(this.myXmlAttributeValue).get((Object)value)) {
                resolved.add(new PsiElementResolveResult(psiElement));
            }
            ResolveResult[] resolveResultArray = resolved.toArray(new ResolveResult[resolved.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facelets/providers/FaceletsUiDefineReferenceProvider$UiDefinePsiReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return super.handleElementRename(newElementName);
        }
    }
}

