/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.xml.application.contracts;

import com.intellij.jsf.references.contracts.JsfContractPsiReference;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsfContractNamesConverter
implements CustomReferenceConverter {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, final PsiElement element, ConvertContext context) {
        final String text = genericDomValue.getStringValue();
        if (text == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/application/contracts/JsfContractNamesConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/application/contracts/JsfContractNamesConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final Set<PsiDirectory> directories = JsfCommonUtils.getContractsDirectories(module);
        final int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        final ArrayList list = new ArrayList();
        new DelimitedListProcessor(", "){

            protected void processToken(int start, int end, boolean delimitersOnly) {
                String dirName = text.substring(start, end);
                String trimmedName = dirName.trim();
                int spacesNumber = dirName.indexOf(trimmedName);
                int startOffset = start + spacesNumber + startInElement;
                int endOffset = startOffset + trimmedName.length();
                list.add(new JsfContractPsiReference(element, directories, TextRange.create((int)startOffset, (int)endOffset)));
            }
        }.processText(text);
        PsiReference[] psiReferenceArray = list.toArray(new PsiReference[list.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/application/contracts/JsfContractNamesConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

