/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.lang.jsp.IBaseJspManager;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseJspManager
implements IBaseJspManager {
    private final Object myLock = new Object();
    private final Project myProject;
    private Reference<XmlNSDescriptor> ourActionsInfo = new SoftReference(null);
    private Reference<XmlNSDescriptor> ourActionsInfo2_1 = new SoftReference(null);
    private Reference<XmlNSDescriptor> ourActionsInfo2_2 = new SoftReference(null);
    private Reference<XmlNSDescriptor> ourDirectivesInfo = new SoftReference(null);
    private Reference<XmlNSDescriptor> ourDirectivesInfo2_1 = new SoftReference(null);
    private Reference<XmlNSDescriptor> ourDirectivesInfo2_2 = new SoftReference(null);

    public BaseJspManager(Project project) {
        this.myProject = project;
    }

    public static BaseJspManager getInstance(Project project) {
        return (BaseJspManager)ServiceManager.getService((Project)project, BaseJspManager.class);
    }

    private static JspVersionImpl getVersionImpl(JspVersion version) {
        if (version instanceof JspVersionImpl) {
            return (JspVersionImpl)version;
        }
        if (version == JspVersion.JSP_2_0) {
            return JspVersionImpl.Jsp2_0;
        }
        if (version == JspVersion.JSP_2_1) {
            return JspVersionImpl.Jsp2_1;
        }
        if (version == JspVersion.JSP_2_2) {
            return JspVersionImpl.Jsp2_2;
        }
        if (version == JspVersion.JSP_2_3) {
            return JspVersionImpl.Jsp2_3;
        }
        throw new RuntimeException(version.toString());
    }

    private static boolean isInvalidDescriptor(XmlNSDescriptor descriptor) {
        return descriptor == null || descriptor.getDescriptorFile() == null || !descriptor.getDescriptorFile().isValid();
    }

    public XmlNSDescriptor getActionsLibrary(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/jsp/BaseJspManager", "getActionsLibrary"));
        }
        return this.getActionsLibrary(BaseJspManager.getJspVersion());
    }

    private static JspVersionImpl getJspVersion() {
        return JspVersionImpl.Jsp2_0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNSDescriptor getActionsLibrary(JspVersion version) {
        XmlNSDescriptor descriptor;
        JspVersionImpl versionImpl = BaseJspManager.getVersionImpl(version);
        Object object = this.myLock;
        synchronized (object) {
            descriptor = versionImpl.getActionsDescriptor(this).get();
        }
        if (BaseJspManager.isInvalidDescriptor(descriptor)) {
            XmlFile file = BaseJspUtil.getResource(versionImpl.getActionsFileName(), this.myProject, this.getClass());
            PsiMetaData psiMetaData = file.getDocument().getMetaData();
            Object object2 = this.myLock;
            synchronized (object2) {
                descriptor = (XmlNSDescriptor)psiMetaData;
                versionImpl.setActionsDescriptor(this, (SoftReference<XmlNSDescriptor>)new SoftReference((Object)descriptor));
            }
        }
        return descriptor;
    }

    @Nullable
    public XmlElementDescriptor getDirectiveDescriptorByName(String name, @NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/jsp/BaseJspManager", "getDirectiveDescriptorByName"));
        }
        return this.getDirectiveDescriptorByName(name, BaseJspManager.getJspVersion());
    }

    public boolean isElIgnored(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/jsp/BaseJspManager", "isElIgnored"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElementDescriptor getDirectiveDescriptorByName(String name, JspVersion version) {
        XmlNSDescriptor descriptor;
        JspVersionImpl versionImpl = BaseJspManager.getVersionImpl(version);
        Object object = this.myLock;
        synchronized (object) {
            descriptor = versionImpl.getDirectiveDescriptor(this).get();
        }
        if (BaseJspManager.isInvalidDescriptor(descriptor)) {
            XmlFile file = BaseJspUtil.getResource(versionImpl.getDirectiveFileName(), this.myProject, this.getClass());
            PsiMetaData data = file.getDocument().getMetaData();
            Object object2 = this.myLock;
            synchronized (object2) {
                descriptor = (XmlNSDescriptor)data;
                versionImpl.setDirectiveDescriptor(this, (SoftReference<XmlNSDescriptor>)new SoftReference((Object)descriptor));
            }
        }
        if (descriptor instanceof XmlNSDescriptorImpl) {
            return ((XmlNSDescriptorImpl)descriptor).getElementDescriptor(name, "http://java.sun.com/JSP/Page");
        }
        return null;
    }

    public static enum JspVersionImpl implements JspVersion
    {
        Jsp2_0(JSP_2_0){

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getDirectiveDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "getDirectiveDescriptor"));
                }
                Reference reference = manager.ourDirectivesInfo;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "getDirectiveDescriptor"));
                }
                return reference;
            }

            @Override
            void setDirectiveDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "setDirectiveDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "setDirectiveDescriptor"));
                }
                manager.ourDirectivesInfo = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getDirectiveFileName() {
                if ("jspdirectives.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "getDirectiveFileName"));
                }
                return "jspdirectives.xsd";
            }

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getActionsDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "getActionsDescriptor"));
                }
                Reference reference = manager.ourActionsInfo;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "getActionsDescriptor"));
                }
                return reference;
            }

            @Override
            void setActionsDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "setActionsDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "setActionsDescriptor"));
                }
                manager.ourActionsInfo = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getActionsFileName() {
                if ("jspxml2.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$1", "getActionsFileName"));
                }
                return "jspxml2.xsd";
            }
        }
        ,
        Jsp2_1(JSP_2_1){

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getDirectiveDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "getDirectiveDescriptor"));
                }
                Reference reference = manager.ourDirectivesInfo2_1;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "getDirectiveDescriptor"));
                }
                return reference;
            }

            @Override
            void setDirectiveDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "setDirectiveDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "setDirectiveDescriptor"));
                }
                manager.ourDirectivesInfo2_1 = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getDirectiveFileName() {
                if ("jspdirectives2_1.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "getDirectiveFileName"));
                }
                return "jspdirectives2_1.xsd";
            }

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getActionsDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "getActionsDescriptor"));
                }
                Reference reference = manager.ourActionsInfo2_1;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "getActionsDescriptor"));
                }
                return reference;
            }

            @Override
            void setActionsDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "setActionsDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "setActionsDescriptor"));
                }
                manager.ourActionsInfo2_1 = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getActionsFileName() {
                if ("jspxml2_1.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$2", "getActionsFileName"));
                }
                return "jspxml2_1.xsd";
            }
        }
        ,
        Jsp2_2(JSP_2_2){

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getDirectiveDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "getDirectiveDescriptor"));
                }
                Reference reference = manager.ourDirectivesInfo2_2;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "getDirectiveDescriptor"));
                }
                return reference;
            }

            @Override
            void setDirectiveDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "setDirectiveDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "setDirectiveDescriptor"));
                }
                manager.ourDirectivesInfo2_2 = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getDirectiveFileName() {
                if ("jspdirectives2_1.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "getDirectiveFileName"));
                }
                return "jspdirectives2_1.xsd";
            }

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getActionsDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "getActionsDescriptor"));
                }
                Reference reference = manager.ourActionsInfo2_2;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "getActionsDescriptor"));
                }
                return reference;
            }

            @Override
            void setActionsDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "setActionsDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "setActionsDescriptor"));
                }
                manager.ourActionsInfo2_2 = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getActionsFileName() {
                if ("jspxml2_1.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$3", "getActionsFileName"));
                }
                return "jspxml2_1.xsd";
            }
        }
        ,
        Jsp2_3(JSP_2_3){

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getDirectiveDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "getDirectiveDescriptor"));
                }
                Reference reference = manager.ourDirectivesInfo2_2;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "getDirectiveDescriptor"));
                }
                return reference;
            }

            @Override
            void setDirectiveDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "setDirectiveDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "setDirectiveDescriptor"));
                }
                manager.ourDirectivesInfo2_2 = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getDirectiveFileName() {
                if ("jspdirectives2_1.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "getDirectiveFileName"));
                }
                return "jspdirectives2_1.xsd";
            }

            @Override
            @NotNull
            Reference<XmlNSDescriptor> getActionsDescriptor(@NotNull BaseJspManager manager) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "getActionsDescriptor"));
                }
                Reference reference = manager.ourActionsInfo2_2;
                if (reference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "getActionsDescriptor"));
                }
                return reference;
            }

            @Override
            void setActionsDescriptor(@NotNull BaseJspManager manager, @NotNull SoftReference<XmlNSDescriptor> descriptor) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "setActionsDescriptor"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "setActionsDescriptor"));
                }
                manager.ourActionsInfo2_2 = descriptor;
            }

            @Override
            @NotNull
            @NonNls
            String getActionsFileName() {
                if ("jspxml2_1.xsd" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/BaseJspManager$JspVersionImpl$4", "getActionsFileName"));
                }
                return "jspxml2_1.xsd";
            }
        };

        private final JspVersion myVersion;

        private JspVersionImpl(JspVersion version) {
            this.myVersion = version;
        }

        @NotNull
        abstract Reference<XmlNSDescriptor> getDirectiveDescriptor(@NotNull BaseJspManager var1);

        abstract void setDirectiveDescriptor(@NotNull BaseJspManager var1, @NotNull SoftReference<XmlNSDescriptor> var2);

        @NonNls
        @NotNull
        abstract String getDirectiveFileName();

        @NotNull
        abstract Reference<XmlNSDescriptor> getActionsDescriptor(@NotNull BaseJspManager var1);

        abstract void setActionsDescriptor(@NotNull BaseJspManager var1, @NotNull SoftReference<XmlNSDescriptor> var2);

        @NonNls
        @NotNull
        abstract String getActionsFileName();

        public String getNumber() {
            return this.myVersion.getNumber();
        }

        public boolean betterThan(JspVersion other) {
            return this.myVersion.betterThan(other);
        }
    }
}

