/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.impl.source.jsp.JspFileIndexEx;
import com.intellij.psi.jsp.BaseJspFile;

public class NewJspFileIndex
extends JspFileIndexEx {
    private final FileIncludeManager myIncludeManager;

    public NewJspFileIndex(PsiManager psiManager, FileIncludeManager includeManager, DumbService dumbService) {
        super(psiManager, dumbService);
        this.myIncludeManager = includeManager;
    }

    @Override
    public void processIncludingFiles(PsiFile file, JspFileIndex.JspFileProcessor jspFileProcessor) {
        this.myIncludeManager.processIncludingFiles(file, pair -> {
            ProgressManager.checkCanceled();
            PsiFile psiFile = this.myPsiManager.findFile((VirtualFile)pair.first);
            return !(psiFile instanceof BaseJspFile) || jspFileProcessor.process((BaseJspFile)psiFile, ((FileIncludeInfo)pair.second).offset, false);
        });
    }

    @Override
    public boolean processIncludedFiles(BaseJspFile file, JspFileIndex.JspFileProcessor processor) {
        VirtualFile[] files;
        VirtualFile base = file.getOriginalFile().getVirtualFile();
        if (base == null) {
            return false;
        }
        for (VirtualFile virtualFile : files = this.myIncludeManager.getIncludedFiles(base, true)) {
            ProgressManager.checkCanceled();
            PsiFile psiFile = this.myPsiManager.findFile(virtualFile);
            if (!(psiFile instanceof BaseJspFile) || processor.process((BaseJspFile)psiFile, 0, true)) continue;
            return false;
        }
        return false;
    }
}

