/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class TaglibsModificationTracker
extends SimpleModificationTracker
implements ModificationTracker {
    @NonNls
    private static final String FACELETS_TAGLIB = ".taglib.xml";
    private final VirtualFileListener myFileListener = new VirtualFileListener(){

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1", "fileCreated"));
            }
            TaglibsModificationTracker.this.incModificationCount();
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1", "fileDeleted"));
            }
            this.fileChanged(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1", "fileMoved"));
            }
            this.fileChanged((VirtualFileEvent)event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1", "propertyChanged"));
            }
            if (event.getPropertyName().equals("name")) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1", "fileCopied"));
            }
            this.fileChanged((VirtualFileEvent)event);
        }

        private void fileChanged(VirtualFileEvent event) {
            if ("tag".equals(event.getFile().getExtension())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1", "contentsChanged"));
            }
            VirtualFile file = event.getFile();
            if (TaglibsModificationTracker.isTaglib(file.getName()) || "jar".equals(file.getExtension())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }
    };
    private final PsiTreeChangeListener myPsiListener = new PsiTreeChangeAdapter(){

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$2", "childAdded"));
            }
            this.processChange(event.getFile());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$2", "childRemoved"));
            }
            this.processChange(event.getFile());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$2", "childReplaced"));
            }
            this.processChange(event.getFile());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$2", "childMoved"));
            }
            this.processChange(event.getFile());
        }

        private void processChange(PsiFile file) {
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null && TaglibsModificationTracker.isTaglib(virtualFile.getName())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$2", "childrenChanged"));
            }
            this.processChange(event.getFile());
        }
    };

    TaglibsModificationTracker(Project project) {
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiListener, (Disposable)project);
        VirtualFileManager.getInstance().addVirtualFileListener(this.myFileListener, (Disposable)project);
    }

    private static boolean isTaglib(@NonNls String name) {
        return name != null && (name.endsWith(".tld") || name.endsWith(FACELETS_TAGLIB) || name.endsWith(".tag"));
    }
}

