/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportListAttribute;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatementImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxStaticImportStatement
extends JspxImportStatementImpl
implements PsiImportStaticStatement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.jspJava.JspxStaticImportStatement");

    public JspxStaticImportStatement(@NotNull JspxImportList list, @NotNull JspxImportListAttribute importList, @NotNull TextRange textRange) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/impl/source/jsp/jspJava/JspxStaticImportStatement", "<init>"));
        }
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/intellij/psi/impl/source/jsp/jspJava/JspxStaticImportStatement", "<init>"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/psi/impl/source/jsp/jspJava/JspxStaticImportStatement", "<init>"));
        }
        super(list, importList, textRange);
    }

    @Nullable
    public PsiClass resolveTargetClass() {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiClass) {
            return (PsiClass)resolved;
        }
        if (resolved instanceof PsiMember) {
            PsiMember member = (PsiMember)resolved;
            return member.getContainingClass();
        }
        return null;
    }

    @Nullable
    public String getReferenceName() {
        if (this.isOnDemand()) {
            return null;
        }
        String fqn = this.getQualifiedName();
        int i = fqn.lastIndexOf(46);
        return i == -1 ? fqn : fqn.substring(i + 1);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String text = this.getText().substring("static ".length());
        String string = text = StringUtil.trimEnd((String)text, (String)".*");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxStaticImportStatement", "getQualifiedName"));
        }
        return string;
    }

    @Override
    protected PsiJavaCodeReferenceElement getResolvingReference(PsiElement resolved) {
        if (resolved instanceof PsiMember) {
            return new LightMemberReference(this.getManager(), (PsiMember)resolved, PsiSubstitutor.EMPTY);
        }
        return super.getResolvingReference(resolved);
    }

    @Override
    public PsiElement resolve() {
        if (this.isOnDemand()) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            PsiPackage aPackage = facade.findPackage(this.getQualifiedName());
            if (aPackage != null) {
                return aPackage;
            }
            return facade.findClass(this.getQualifiedName(), this.getResolveScope());
        }
        String fqn = this.getQualifiedName();
        return JavaClassReference.resolveMember((String)fqn, (PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/jspJava/JspxStaticImportStatement", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStaticStatement((PsiImportStaticStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "Jspx static import " + this.getQualifiedName();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JspxStaticImportStatement)) {
            return false;
        }
        JspxStaticImportStatement other = (JspxStaticImportStatement)((Object)object);
        return this.getContainingFile() == other.getContainingFile() && this.isOnDemand() == other.isOnDemand() && Comparing.strEqual((String)this.getQualifiedName(), (String)other.getQualifiedName());
    }

    @Override
    public PsiElement copy() {
        try {
            return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createStatementFromText("import static " + this.getQualifiedName() + (this.isOnDemand() ? ".*" : ""), (PsiElement)this);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

