/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.jsp;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.ELElementType;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspLexer2
extends LexerBase {
    private CharSequence myBuffer;
    private char[] myBufferArray;
    private int myBufferEnd;
    private int myState;
    private int myLexerState;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;
    private final String[] myKnownPrefixes;
    private final boolean myHighlightingMode;
    private final boolean mySpecialWhitespacesInTemplates;
    public static final int TEMPLATE = 0;
    public static final int ACTION_START = 1;
    public static final int ATT_LIST = 2;
    public static final int ATTR = 3;
    public static final int ATT_VALUE_SQ = 4;
    public static final int ATT_VALUE_DQ = 5;
    public static final int ACTION_END = 6;
    @NonNls
    private static final String SCRIPTLET_START = "<%";
    private boolean myElIgnored;
    private int myCurlyBracketCount;

    public JspLexer2(Set<String> prefixes, boolean highlightingMode, boolean specialWhitespacesInTemplates) {
        this.mySpecialWhitespacesInTemplates = specialWhitespacesInTemplates;
        this.myHighlightingMode = highlightingMode;
        this.myKnownPrefixes = ArrayUtil.toStringArray(prefixes);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/parsing/jsp/JspLexer2", "start"));
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        this.myTokenType = null;
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myLexerState = this.myState = initialState;
        this.myCurlyBracketCount = 0;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/jsp/JspLexer2", "getBufferSequence"));
        }
        return charSequence;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public int getState() {
        return this.myLexerState;
    }

    public void restore(int start, int end, int state, IElementType token) {
        this.myTokenStart = start;
        this.myTokenEnd = end;
        this.myLexerState = this.myState = state;
        this.myTokenType = token;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public void advance() {
        this.myTokenType = null;
    }

    private void locateToken() {
        int cur;
        if (this.myTokenType != null) {
            return;
        }
        this.myLexerState = this.myState;
        int end = this.myBufferEnd;
        CharSequence buf = this.myBuffer;
        char[] bufArray = this.myBufferArray;
        if (cur >= end) {
            this.myTokenType = null;
            return;
        }
        if (this.myState == 0) {
            for (cur = this.myTokenStart = this.myTokenEnd; cur < end; ++cur) {
                char curChar;
                char c = curChar = bufArray != null ? bufArray[cur] : buf.charAt(cur);
                if (!(this.myHighlightingMode || curChar != ' ' && curChar != '\t' && curChar != '\n')) {
                    if (cur > this.myTokenStart) {
                        this.myTokenEnd = cur;
                        this.myTokenType = JspTokenType.JSP_TEMPLATE_DATA;
                        return;
                    }
                    while (cur < end) {
                        char c2;
                        char c3 = c2 = bufArray != null ? bufArray[cur] : buf.charAt(cur);
                        if (c2 != ' ' && c2 != '\t' && c2 != '\n') break;
                        ++cur;
                    }
                    this.myTokenEnd = cur;
                    this.myTokenType = this.mySpecialWhitespacesInTemplates ? XmlTokenType.XML_REAL_WHITE_SPACE : XmlTokenType.XML_WHITE_SPACE;
                    return;
                }
                if (curChar == '<') {
                    if (this.matches(buf, bufArray, cur, end, "<%--", "--%>", JspTokenType.JSP_COMMENT, JspTokenType.JSP_TEMPLATE_DATA, false, false, false, false)) {
                        return;
                    }
                    if (this.matches(buf, bufArray, cur, end, "<%@", "%>", (IElementType)BaseJspElementType.JSP_DIRECTIVE, JspTokenType.JSP_TEMPLATE_DATA, true, false, false, false)) {
                        return;
                    }
                    if (this.matches(buf, bufArray, cur, end, "<%!", "%>", (IElementType)BaseJspElementType.JSP_DECLARATION, JspTokenType.JSP_TEMPLATE_DATA, true, false, false, false)) {
                        return;
                    }
                    if (this.matches(buf, bufArray, cur, end, "<%=", "%>", (IElementType)BaseJspElementType.JSP_EXPRESSION, JspTokenType.JSP_TEMPLATE_DATA, true, false, false, false)) {
                        return;
                    }
                    if (this.matches(buf, bufArray, cur, end, SCRIPTLET_START, "%>", (IElementType)BaseJspElementType.JSP_SCRIPTLET, JspTokenType.JSP_TEMPLATE_DATA, true, false, false, false)) {
                        return;
                    }
                    if (this.lookupPrefix(buf, bufArray, cur + 1, end)) {
                        if (cur > this.myTokenStart) break;
                        this.myState = 1;
                        this.myTokenType = XmlTokenType.XML_START_TAG_START;
                        this.myTokenEnd = cur + 1;
                        return;
                    }
                    if (cur + 1 >= end || (bufArray != null ? bufArray[cur + 1] : buf.charAt(cur + 1)) != '/' || !this.lookupPrefix(buf, bufArray, cur + 2, end)) continue;
                    if (cur > this.myTokenStart) break;
                    this.myState = 6;
                    this.myTokenType = XmlTokenType.XML_END_TAG_START;
                    this.myTokenEnd = cur + 2;
                    return;
                }
                if (!(!this.myElIgnored && curChar == '$' && (cur == this.myTokenStart || (bufArray != null ? bufArray[cur - 1] : buf.charAt(cur - 1)) != '\\') ? this.matches(buf, bufArray, cur, end, "${", "}", (IElementType)ELElementType.JSP_EL_HOLDER, JspTokenType.JSP_TEMPLATE_DATA, true, true, false, false) : !this.myElIgnored && curChar == '#' && (cur == this.myTokenStart || (bufArray != null ? bufArray[cur - 1] : buf.charAt(cur - 1)) != '\\') && this.matches(buf, bufArray, cur, end, "#{", "}", (IElementType)ELElementType.JSP_EL_HOLDER, JspTokenType.JSP_TEMPLATE_DATA, true, true, false, false))) continue;
                return;
            }
            this.myTokenType = JspTokenType.JSP_TEMPLATE_DATA;
            this.myTokenEnd = cur;
            return;
        }
        if (this.myState == 1) {
            char c;
            if (this.matchXmlName(buf, bufArray, cur, end, this.myHighlightingMode ? XmlTokenType.XML_TAG_NAME : XmlTokenType.XML_NAME)) {
                this.myState = 2;
                return;
            }
            char c4 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (c == '>') {
                this.myTokenType = XmlTokenType.XML_TAG_END;
                this.myTokenEnd = cur + 1;
                this.myState = 0;
                return;
            }
            if (c == '/' && cur + 1 < end && (bufArray != null ? bufArray[cur + 1] : buf.charAt(cur + 1)) == '>') {
                this.myTokenType = XmlTokenType.XML_EMPTY_ELEMENT_END;
                this.myTokenEnd = cur + 2;
                this.myState = 0;
                return;
            }
            this.myState = 0;
            this.locateToken();
            return;
        }
        if (this.myState == 2) {
            if (this.matchXmlName(buf, bufArray, cur, end, XmlTokenType.XML_NAME)) {
                this.myState = 3;
                return;
            }
            if (this.matchSpaces(buf, bufArray, cur, end)) {
                return;
            }
            this.myState = 1;
            this.locateToken();
            return;
        }
        if (this.myState == 3) {
            char c;
            if ((bufArray != null ? bufArray[cur] : buf.charAt(cur)) == '=') {
                this.myTokenType = XmlTokenType.XML_EQ;
                this.myTokenEnd = cur + 1;
                return;
            }
            if (this.matchSpaces(buf, bufArray, cur, end)) {
                return;
            }
            char c5 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (c == '\'') {
                this.myTokenType = XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                this.myTokenEnd = cur + 1;
                this.myState = 4;
                return;
            }
            if (c == '\"') {
                this.myTokenType = XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                this.myTokenEnd = cur + 1;
                this.myState = 5;
                return;
            }
            this.myState = 2;
            this.locateToken();
            return;
        }
        if (this.myState == 4 || this.myState == 5) {
            char c;
            char c6 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (c == '\'' && this.myState == 4 || c == '\"' && this.myState == 5) {
                this.myTokenType = XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
                this.myTokenEnd = cur + 1;
                this.myState = 2;
                return;
            }
            boolean esc = false;
            while (cur < end) {
                char c7 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
                if (!esc) {
                    if (c == '\\') {
                        esc = true;
                    } else {
                        if (c == '\'' && this.myState == 4 || c == '\"' && this.myState == 5) break;
                        if (!this.myElIgnored && c == '$' && this.matches(buf, bufArray, cur, end, "${", "}", (IElementType)ELElementType.JSP_EL_HOLDER, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, true, true, this.myState == 4, this.myState == 5)) {
                            return;
                        }
                        if (!this.myElIgnored && c == '#' && this.matches(buf, bufArray, cur, end, "#{", "}", (IElementType)ELElementType.JSP_EL_HOLDER, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, true, true, this.myState == 4, this.myState == 5)) {
                            return;
                        }
                        if (c == '<' && this.matches(buf, bufArray, cur, end, "<%=", "%>", (IElementType)BaseJspElementType.JSP_EXPRESSION, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, true, false, false, false)) {
                            return;
                        }
                    }
                } else {
                    esc = false;
                }
                ++cur;
            }
            this.myTokenType = XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            this.myTokenEnd = cur;
            return;
        }
        if (this.myState == 6) {
            char c;
            if (this.matchXmlName(buf, bufArray, cur, end, this.myHighlightingMode ? XmlTokenType.XML_TAG_NAME : XmlTokenType.XML_NAME)) {
                return;
            }
            if (this.matchSpaces(buf, bufArray, cur, end)) {
                return;
            }
            char c8 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (c == '/' && cur + 1 < end && (bufArray != null ? bufArray[cur + 1] : buf.charAt(cur + 1)) == '>') {
                this.myTokenType = XmlTokenType.XML_TAG_END;
                this.myTokenEnd = cur + 2;
                this.myState = 0;
                return;
            }
            if (c == '>') {
                this.myTokenType = XmlTokenType.XML_TAG_END;
                this.myTokenEnd = cur + 1;
                this.myState = 0;
                return;
            }
            this.myState = 0;
            this.locateToken();
            return;
        }
    }

    private boolean matchSpaces(CharSequence buf, char[] charBuf, int start, int end) {
        int cur;
        for (cur = start; cur < end; ++cur) {
            char c;
            char c2 = c = charBuf != null ? charBuf[cur] : buf.charAt(cur);
            if (c != ' ' && c != '\n' && c != '\t') break;
        }
        if (cur > start) {
            this.myTokenType = XmlTokenType.XML_WHITE_SPACE;
            this.myTokenEnd = cur;
            return true;
        }
        return false;
    }

    private boolean matchXmlName(CharSequence buf, char[] bufArray, int start, int end, IElementType token) {
        int cur;
        for (cur = start; cur < end; ++cur) {
            char c;
            char c2 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (!Character.isJavaIdentifierPart(c) && c != ':' && c != '.' && c != '-') break;
        }
        if (cur > start) {
            this.myTokenType = token;
            this.myTokenEnd = cur;
            return true;
        }
        return false;
    }

    private boolean lookupPrefix(CharSequence buf, char[] bufArray, int start, int end) {
        for (int i = start; i < Math.min(start + 20, end); ++i) {
            char c;
            if (this.myKnownPrefixes.length == 0) {
                return true;
            }
            char c2 = c = bufArray != null ? bufArray[i] : buf.charAt(i);
            if (c == ':') {
                return i + 1 < end && XmlUtil.isValidTagNameChar((char)(bufArray != null ? bufArray[i + 1] : buf.charAt(i + 1))) && !this.isXmlPrefix(buf, bufArray, start, i);
            }
            if (XmlUtil.isValidTagNameChar((char)c)) continue;
            return false;
        }
        return false;
    }

    private boolean isXmlPrefix(CharSequence buf, char[] bufArray, int start, int end) {
        block0: for (String prefix : this.myKnownPrefixes) {
            int prefixStop;
            if (prefix == null || "jsp".equals(prefix) || (prefixStop = start + prefix.length()) != end) continue;
            for (int i = start; i < prefixStop; ++i) {
                char c;
                char c2 = c = bufArray != null ? bufArray[i] : buf.charAt(i);
                if (c != prefix.charAt(i - start)) continue block0;
            }
            return true;
        }
        return false;
    }

    private boolean matches(CharSequence buf, char[] bufArray, int start, int end, String prefix, String suffix, IElementType token, IElementType surroundingToken, boolean doStopAtScriptletPrefix, boolean escapeInQuotes, boolean doStopAtUnescapedSQ, boolean doStopAtUnescapedDQ) {
        int cur;
        int prefixStop = start + prefix.length();
        if (prefixStop > end) {
            return false;
        }
        for (cur = start; cur < prefixStop; ++cur) {
            char c;
            char c2 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (c == prefix.charAt(cur - start)) continue;
            return false;
        }
        if (start > this.myTokenStart) {
            this.myTokenType = surroundingToken;
            this.myTokenEnd = start;
            return true;
        }
        boolean sq = false;
        boolean dq = false;
        boolean esc = false;
        char firstCharInSuffix = suffix.charAt(0);
        while (cur < end) {
            char c;
            char c3 = c = bufArray != null ? bufArray[cur] : buf.charAt(cur);
            if (!esc) {
                if (c == '\\') {
                    esc = true;
                } else if (c == '\'') {
                    if (doStopAtUnescapedSQ) {
                        this.myTokenType = token;
                        this.myTokenEnd = cur;
                        return true;
                    }
                    sq = !sq;
                } else if (c == '\"') {
                    if (doStopAtUnescapedDQ) {
                        this.myTokenType = token;
                        this.myTokenEnd = cur;
                        return true;
                    }
                    dq = !dq;
                }
            } else {
                esc = false;
            }
            if (doStopAtScriptletPrefix && c == '<' && (bufArray != null && CharArrayUtil.regionMatches((char[])bufArray, (int)cur, (int)end, (CharSequence)SCRIPTLET_START) || bufArray == null && CharArrayUtil.regionMatches((CharSequence)buf, (int)cur, (int)end, (CharSequence)SCRIPTLET_START))) {
                this.myTokenType = token;
                this.myTokenEnd = cur;
                this.myState = 0;
                return true;
            }
            if (!escapeInQuotes || !sq && !dq) {
                if (c == '{' && firstCharInSuffix == '}') {
                    ++this.myCurlyBracketCount;
                } else if (c == '}' && this.myCurlyBracketCount > 0) {
                    --this.myCurlyBracketCount;
                } else if (c == firstCharInSuffix && (bufArray != null && CharArrayUtil.regionMatches((char[])bufArray, (int)cur, (int)end, (CharSequence)suffix) || bufArray == null && CharArrayUtil.regionMatches((CharSequence)buf, (int)cur, (int)end, (CharSequence)suffix))) {
                    this.myTokenType = token;
                    this.myTokenEnd = cur + suffix.length();
                    return true;
                }
            }
            ++cur;
        }
        this.myTokenType = token;
        this.myTokenEnd = cur;
        return true;
    }

    public int getAfterState() {
        return this.myState;
    }

    public void setElIgnored(boolean elIgnored) {
        this.myElIgnored = elIgnored;
    }
}

