/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.XmlValueReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaglibReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
        }
        XmlTag tag = (XmlTag)element;
        String localName = tag.getLocalName();
        if ("name".equals(localName)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if ("name-given".equals(localName) || "function-name".equals(localName) || "tag-name".equals(localName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new NameReference(tag)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if ("function-signature".equals(localName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new MethodReference(tag)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if ("path".equals(localName) || "source".equals(localName)) {
            TextRange textRangeInTagValue = ElementManipulators.getValueTextRange((PsiElement)tag);
            FileReference[] fileReferenceArray = new FileReferenceSet(tag.getValue().getText().trim(), (PsiElement)tag, textRangeInTagValue.getStartOffset(), (PsiReferenceProvider)this, true).getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static class MethodReference
    extends XmlValueReference
    implements EmptyResolveMessageProvider {
        private String myUnresolvedMessage;

        MethodReference(XmlTag tag) {
            super(tag);
        }

        private JavaClassReference findFunctionClassReference() {
            PsiReference lastReference;
            PsiReference[] references;
            XmlTag tag;
            XmlTag clazzTag;
            PsiElement parent = this.myTag.getParent();
            if (parent instanceof XmlTag && (clazzTag = (tag = (XmlTag)parent).findFirstSubTag("function-class")) != null && (references = clazzTag.getReferences()).length > 0 && (lastReference = references[references.length - 1]) instanceof JavaClassReference) {
                return (JavaClassReference)lastReference;
            }
            return null;
        }

        private PsiClass resolveClass() {
            PsiElement psiElement;
            JavaClassReference lastReference = this.findFunctionClassReference();
            if (lastReference != null && (psiElement = lastReference.resolve()) instanceof PsiClass) {
                return (PsiClass)psiElement;
            }
            return null;
        }

        @Nullable
        public PsiElement resolve() {
            this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.class.is.not.valid", (Object[])new Object[0]);
            PsiClass clazz = this.resolveClass();
            if (clazz == null) {
                return null;
            }
            if (!clazz.hasModifierProperty("public")) {
                this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.class.is.not.public", (Object[])new Object[0]);
                return null;
            }
            PsiMetaData metaData = ((XmlTag)this.myTag.getParent()).getMetaData();
            if (metaData instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)metaData;
                PsiMethod[] methodsByName = clazz.findMethodsByName(functionDescriptor.getFunctionName(), false);
                this.myUnresolvedMessage = methodsByName.length == 0 ? PsiBundle.message((String)"jsp.taglib.method.reference.error.no.such.method", (Object[])new Object[0]) : PsiBundle.message((String)"jsp.taglib.method.reference.error.method.should.be.public.or.static", (Object[])new Object[0]);
                for (int i = 0; i < methodsByName.length; ++i) {
                    PsiMethod psiMethod = methodsByName[i];
                    if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.signature.is.different", (Object[])new Object[0]);
                    if (parameters.length != functionDescriptor.getParameterCount()) continue;
                    boolean matched = true;
                    int j = 0;
                    for (String parameterType : functionDescriptor.getFunctionParameters()) {
                        if (!MethodReference.isSameType(parameterType, parameters[j].getType().getCanonicalText())) {
                            matched = false;
                            break;
                        }
                        ++j;
                    }
                    if (!matched) continue;
                    if (MethodReference.isSameType(functionDescriptor.getFunctionReturnType(), psiMethod.getReturnType().getCanonicalText())) {
                        this.myUnresolvedMessage = "";
                        return psiMethod;
                    }
                    this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.different.return.type", (Object[])new Object[0]);
                    return null;
                }
            }
            return null;
        }

        private static boolean isSameType(String functionReturnType, String returnTypeText) {
            return functionReturnType.equals(returnTypeText) || returnTypeText.startsWith(functionReturnType) && returnTypeText.charAt(functionReturnType.length()) == '<' && returnTypeText.charAt(returnTypeText.length() - 1) == '>';
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiMetaData metaData = ((XmlTag)this.myTag.getParent()).getMetaData();
            if (metaData instanceof FunctionDescriptor) {
                FunctionDescriptor descriptor = (FunctionDescriptor)metaData;
                StringBuffer newsignature = new StringBuffer(descriptor.getFunctionSignature().length());
                newsignature.append(descriptor.getFunctionReturnType()).append(" ").append(newElementName).append('(');
                boolean first = true;
                for (String parameterType : descriptor.getFunctionParameters()) {
                    if (!first) {
                        newsignature.append(',');
                    }
                    first = false;
                    newsignature.append(parameterType);
                }
                newsignature.append(')');
                this.replaceContent(newsignature.toString());
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$MethodReference", "bindToElement"));
            }
            JavaClassReference javaClassReference = this.findFunctionClassReference();
            if (javaClassReference != null) {
                javaClassReference.bindToElement(element.getParent());
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            PsiClass psiClass = this.resolveClass();
            if (psiClass != null && psiClass.hasModifierProperty("public")) {
                PsiMethod[] allMethods = psiClass.getAllMethods();
                ArrayList<String> candidates = new ArrayList<String>(1);
                for (PsiMethod method : allMethods) {
                    if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
                    StringBuffer signature = new StringBuffer();
                    signature.append(MethodReference.buildTypeImage(method.getReturnType()));
                    signature.append(" ");
                    signature.append(method.getName());
                    signature.append("(");
                    boolean first = true;
                    for (PsiParameter parameter : method.getParameterList().getParameters()) {
                        if (!first) {
                            signature.append(",");
                        }
                        signature.append(MethodReference.buildTypeImage(parameter.getType()));
                        first = false;
                    }
                    signature.append(")");
                    candidates.add(signature.toString());
                }
                Object[] objectArray = ArrayUtil.toStringArray(candidates);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$MethodReference", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$MethodReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        private static String buildTypeImage(PsiType returnType) {
            if (returnType == null) {
                return null;
            }
            String image = returnType.getCanonicalText();
            int gt = image.indexOf(60);
            if (gt != -1) {
                image = image.substring(0, gt);
            }
            return image;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = this.myUnresolvedMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$MethodReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }

    static class NameReference
    extends XmlValueReference {
        protected NameReference(XmlTag tag) {
            super(tag);
        }

        @Nullable
        public PsiElement resolve() {
            return this.myTag.getParent();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            this.replaceContent(newElementName);
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$NameReference", "bindToElement"));
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$NameReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

