/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.jps;

import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/jps/KotlinAndroidJpsPlugin;", "Lorg/jetbrains/kotlin/jps/build/KotlinJpsCompilerArgumentsProvider;", "()V", "getAndroidManifest", "Ljava/io/File;", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "getAndroidResPath", "", "getClasspath", "", "moduleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getExtraArguments", "hasAndroidJpsPlugin", "", "isAndroidModuleWithoutGradle", "Companion", "android-extensions-jps"})
public final class KotlinAndroidJpsPlugin
implements KotlinJpsCompilerArgumentsProvider {
    private static final String ANDROID_JPS_UTIL_CLASS_FQNAME = "org.jetbrains.jps.android.AndroidJpsUtil";
    private static final String JAR_FILE_NAME = "kotlin-android-extensions-compiler-plugin.jar";
    private static final String ANDROID_COMPILER_PLUGIN_ID = "org.jetbrains.kotlin.android";
    private static final String VARIANT_OPTION_NAME = "variant";
    private static final String PACKAGE_OPTION_NAME = "package";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> getExtraArguments(@NotNull ModuleBuildTarget moduleBuildTarget, @NotNull CompileContext context) {
        String string;
        JpsModule module;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)moduleBuildTarget, (String)"moduleBuildTarget");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                module = moduleBuildTarget.getModule();
                if (!this.hasAndroidJpsPlugin()) break block5;
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                if (this.isAndroidModuleWithoutGradle(jpsModule)) break block6;
            }
            return CollectionsKt.emptyList();
        }
        String pluginId = KotlinAndroidJpsPlugin.Companion.getANDROID_COMPILER_PLUGIN_ID();
        JpsModule jpsModule = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
        String resPath = this.getAndroidResPath(jpsModule);
        JpsModule jpsModule2 = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule2, (String)"module");
        File file = this.getAndroidManifest(jpsModule2);
        if (file != null) {
            File file2;
            File it = file2 = file;
            string = KotlinAndroidJpsPlugin.Companion.getApplicationPackageFromManifest(it);
        } else {
            string = null;
        }
        String applicationId = string;
        return resPath != null && applicationId != null ? CollectionsKt.listOf((Object[])new String[]{KotlinAndroidJpsPlugin.Companion.getPluginOptionString(pluginId, KotlinAndroidJpsPlugin.Companion.getVARIANT_OPTION_NAME(), "main;" + resPath), KotlinAndroidJpsPlugin.Companion.getPluginOptionString(pluginId, KotlinAndroidJpsPlugin.Companion.getPACKAGE_OPTION_NAME(), applicationId)}) : CollectionsKt.emptyList();
    }

    private final boolean isAndroidModuleWithoutGradle(JpsModule module) {
        JpsAndroidModuleExtension jpsAndroidModuleExtension = AndroidJpsUtil.getExtension((JpsModule)module);
        if (jpsAndroidModuleExtension == null) {
            return false;
        }
        JpsAndroidModuleExtension androidFacet = jpsAndroidModuleExtension;
        return !androidFacet.isGradleProject();
    }

    private final boolean hasAndroidJpsPlugin() {
        try {
            Class.forName(KotlinAndroidJpsPlugin.Companion.getANDROID_JPS_UTIL_CLASS_FQNAME());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public List<String> getClasspath(@NotNull ModuleBuildTarget moduleBuildTarget, @NotNull CompileContext context) {
        List list;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)moduleBuildTarget, (String)"moduleBuildTarget");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                JpsModule module = moduleBuildTarget.getModule();
                if (!this.hasAndroidJpsPlugin()) break block7;
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                if (this.isAndroidModuleWithoutGradle(jpsModule)) break block8;
            }
            return CollectionsKt.emptyList();
        }
        boolean inJar = new File(PathUtil.getJarPathForClass(this.getClass())).isFile();
        JpsModule jpsModule = moduleBuildTarget.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"moduleBuildTarget.module");
        File manifestFile = this.getAndroidManifest(jpsModule);
        if (manifestFile != null) {
            String string;
            if (inJar) {
                File libDirectory = new File(PathUtil.getJarPathForClass(this.getClass())).getParentFile().getParentFile();
                string = new File(libDirectory, KotlinAndroidJpsPlugin.Companion.getJAR_FILE_NAME()).getAbsolutePath();
            } else {
                File kotlinProjectDirectory = new File(PathUtil.getJarPathForClass(this.getClass())).getParentFile().getParentFile().getParentFile();
                string = new File(kotlinProjectDirectory, "dist/kotlinc/lib/" + KotlinAndroidJpsPlugin.Companion.getJAR_FILE_NAME()).getAbsolutePath();
            }
            list = CollectionsKt.listOf((Object)string);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getAndroidResPath(JpsModule module) {
        JpsAndroidModuleExtension jpsAndroidModuleExtension = AndroidJpsUtil.getExtension((JpsModule)module);
        if (jpsAndroidModuleExtension == null) {
            return null;
        }
        JpsAndroidModuleExtension extension = jpsAndroidModuleExtension;
        File file = AndroidJpsUtil.getResourceDirForCompilationPath((JpsAndroidModuleExtension)extension);
        return file != null ? file.getAbsolutePath() : null;
    }

    private final File getAndroidManifest(JpsModule module) {
        JpsAndroidModuleExtension jpsAndroidModuleExtension = AndroidJpsUtil.getExtension((JpsModule)module);
        if (jpsAndroidModuleExtension == null) {
            return null;
        }
        JpsAndroidModuleExtension extension = jpsAndroidModuleExtension;
        return AndroidJpsUtil.getManifestFileForCompilationPath((JpsAndroidModuleExtension)extension);
    }

    static {
        ANDROID_JPS_UTIL_CLASS_FQNAME = ANDROID_JPS_UTIL_CLASS_FQNAME;
        JAR_FILE_NAME = JAR_FILE_NAME;
        ANDROID_COMPILER_PLUGIN_ID = ANDROID_COMPILER_PLUGIN_ID;
        VARIANT_OPTION_NAME = VARIANT_OPTION_NAME;
        PACKAGE_OPTION_NAME = PACKAGE_OPTION_NAME;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/android/jps/KotlinAndroidJpsPlugin$Companion;", "", "()V", "ANDROID_COMPILER_PLUGIN_ID", "", "getANDROID_COMPILER_PLUGIN_ID", "()Ljava/lang/String;", "ANDROID_JPS_UTIL_CLASS_FQNAME", "getANDROID_JPS_UTIL_CLASS_FQNAME", "JAR_FILE_NAME", "getJAR_FILE_NAME", "PACKAGE_OPTION_NAME", "getPACKAGE_OPTION_NAME", "VARIANT_OPTION_NAME", "getVARIANT_OPTION_NAME", "getApplicationPackageFromManifest", "manifestFile", "Ljava/io/File;", "getPluginOptionString", "pluginId", "key", "value", "parseXml", "Lorg/w3c/dom/Document;", "android-extensions-jps"})
    public static final class Companion {
        private final String getANDROID_JPS_UTIL_CLASS_FQNAME() {
            return ANDROID_JPS_UTIL_CLASS_FQNAME;
        }

        private final String getJAR_FILE_NAME() {
            return JAR_FILE_NAME;
        }

        private final String getANDROID_COMPILER_PLUGIN_ID() {
            return ANDROID_COMPILER_PLUGIN_ID;
        }

        private final String getVARIANT_OPTION_NAME() {
            return VARIANT_OPTION_NAME;
        }

        private final String getPACKAGE_OPTION_NAME() {
            return PACKAGE_OPTION_NAME;
        }

        private final String getApplicationPackageFromManifest(File manifestFile) {
            try {
                return this.parseXml(manifestFile).getDocumentElement().getAttribute(KotlinAndroidJpsPlugin.PACKAGE_OPTION_NAME);
            }
            catch (Exception e) {
                return null;
            }
        }

        private final Document parseXml(@NotNull File $receiver) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse($receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"builder.parse(this)");
            return document;
        }

        private final String getPluginOptionString(String pluginId, String key, String value) {
            return "plugin:" + pluginId + ":" + key + "=" + value;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

