/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class ErrorRecord
implements Comparable<ErrorRecord>,
Serializable {
    private final long myLineNumber;

    protected ErrorRecord(long number) {
        this.myLineNumber = number;
    }

    @NotNull
    public abstract String getMessage();

    protected long getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public int compareTo(@NotNull ErrorRecord o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/remote/dbimport/ErrorRecord", "compareTo"));
        }
        return this.getLineNumber() > o.getLineNumber() ? 1 : (this.getLineNumber() < o.getLineNumber() ? -1 : 0);
    }

    public static class ExceptionRecord
    extends ErrorRecord {
        private final Exception myException;

        public ExceptionRecord(@NotNull Exception exception, long number) {
            if (exception == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/database/remote/dbimport/ErrorRecord$ExceptionRecord", "<init>"));
            }
            super(number);
            this.myException = exception;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = this.getLineNumber() + ": " + this.getErrorText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/ErrorRecord$ExceptionRecord", "getMessage"));
            }
            return string;
        }

        @NotNull
        protected String getErrorText() {
            String string = StringUtil.convertLineSeparators((String)this.myException.getMessage(), (String)" ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/ErrorRecord$ExceptionRecord", "getErrorText"));
            }
            return string;
        }
    }
}

