/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.PreparedBatchQuery;
import com.intellij.database.remote.dbimport.Query;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExecuteBatchQuery
implements Query {
    private final List<PreparedBatchQuery> myAllQueries;
    private final RemotePreparedStatement myStatement;

    ExecuteBatchQuery(@NotNull List<PreparedBatchQuery> allQueries, @NotNull RemotePreparedStatement statement) {
        if (allQueries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allQueries", "com/intellij/database/remote/dbimport/ExecuteBatchQuery", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/dbimport/ExecuteBatchQuery", "<init>"));
        }
        this.myStatement = statement;
        this.myAllQueries = allQueries;
    }

    @Override
    public void execute() throws RemoteException, SQLException {
        try {
            this.myStatement.executeBatch();
        }
        catch (RemoteBatchPreparedStatementImpl.IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException e) {
            ExecuteBatchQuery.executeWithoutBatch(this.myAllQueries, this.myAllQueries.size());
        }
    }

    public static void executeWithoutBatch(@NotNull List<PreparedBatchQuery> queries, int lastQuery) throws RemoteException, SQLException {
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/remote/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        for (int i = 0; i < lastQuery; ++i) {
            queries.get(i).executeWithoutBatch();
        }
    }
}

