/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.ZonedInfo;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;

public class JdbcNativeUtil {
    public static final String PG_TIMESTAMP_TZ_NAME = "timestamptz";
    private static final String PG_TIME_TZ_NAME = "timetz";
    private static final String ESCAPE_SYMBOL = "#";

    public static boolean isRedshiftOrPostgres(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isRedshiftOrPostgres"));
        }
        return rdbms == Postgres.RDBMS || rdbms.code.equalsIgnoreCase("redshift");
    }

    public static void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull Rdbms rdbms, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setStatementParameter"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setStatementParameter"));
        }
        if (columnInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfo", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setStatementParameter"));
        }
        String typeName = columnInfo.getTypeName();
        int type = columnInfo.getType();
        String javaClassName = columnInfo.getJavaClassName();
        if (value == null) {
            statement.setNull(idx, JdbcNativeUtil.isPgUuidColumn(typeName, rdbms) ? 1111 : type);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setBlob(idx, new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setClob(idx, new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof LobInfo.ClobInfo) {
            statement.setString(idx, JdbcNativeUtil.escapeSql(((LobInfo.ClobInfo)value).data, needsEscaping, rdbms));
        } else if (value instanceof byte[]) {
            statement.setBytes(idx, (byte[])value);
        } else if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && type == 2003 && value instanceof Object[]) {
            statement.setArray(idx, StringUtil.replace((String)typeName, (String)"_", (String)""), (Object[])value);
        } else if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && (Arrays.asList("bit", "varbit", "tid", "uuid", "money", "interval").contains(typeName) || type == 2003 || type == 2002 || type == 1111 || Object.class.getName().equals(javaClassName))) {
            statement.setObject(idx, value, 1111);
        } else if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && type == 2009) {
            statement.setObject(idx, JdbcNativeUtil.escapeSql(value, needsEscaping, rdbms), 2009);
        } else if (value instanceof java.util.Date) {
            JdbcNativeUtil.setDate(statement, value, rdbms, idx, type);
        } else if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && JdbcNativeUtil.isZonedColumn(typeName, rdbms)) {
            JdbcNativeUtil.setZonedValue(statement, typeName, (ZonedInfo)value, rdbms, needsEscaping, idx);
        } else if (type == -5 && value instanceof BigInteger) {
            JdbcNativeUtil.setBigInteger(rdbms, statement, (BigInteger)value, idx);
        } else {
            statement.setObject(idx, JdbcNativeUtil.escapeSql(value, needsEscaping, rdbms));
        }
    }

    private static void setDate(@NotNull RemotePreparedStatement statement, @NotNull Object value, @NotNull Rdbms rdbms, int idx, int type) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setDate"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setDate"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setDate"));
        }
        long millis = ((java.util.Date)value).getTime();
        if (JdbcNativeUtil.isTimestamp(rdbms, type)) {
            statement.setTimestamp(idx, value instanceof Timestamp ? (Timestamp)value : new Timestamp(millis));
            return;
        }
        if (type == 92) {
            statement.setTime(idx, value instanceof Time ? (Time)value : new Time(millis));
            return;
        }
        statement.setDate(idx, value instanceof Date ? (Date)value : new Date(millis));
    }

    public static boolean isTimestamp(@NotNull Rdbms rdbms, int type) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isTimestamp"));
        }
        return type == 93 || rdbms == Mssql.RDBMS && type == -151;
    }

    private static void setZonedValue(@NotNull RemotePreparedStatement statement, @NotNull String typeName, @NotNull ZonedInfo value, @NotNull Rdbms dbms, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (dbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (JdbcNativeUtil.isZonedTimestampColumn(typeName, dbms)) {
            statement.setObject(idx, JdbcNativeUtil.escapeSql(value.getStringRepresentation(), needsEscaping, dbms), value.getType());
        } else {
            Time time = (Time)value.getDate();
            statement.setTime(idx, time, value.getCalendar());
        }
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull Rdbms rdbms) {
        Object[] objectArray;
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "escapeSql"));
        }
        if (!needsEscaping) {
            return value;
        }
        if (rdbms == Sqlite.RDBMS) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        if (rdbms == Mysql.RDBMS) {
            String[] stringArray = new String[4];
            stringArray[0] = "%";
            stringArray[1] = "_";
            stringArray[2] = "\\";
            objectArray = stringArray;
            stringArray[3] = ESCAPE_SYMBOL;
        } else if (rdbms == Mssql.RDBMS) {
            String[] stringArray = new String[5];
            stringArray[0] = "%";
            stringArray[1] = "_";
            stringArray[2] = "[";
            stringArray[3] = "]";
            objectArray = stringArray;
            stringArray[4] = ESCAPE_SYMBOL;
        } else {
            Object[] objectArray2 = new String[3];
            objectArray2[0] = "%";
            objectArray2[1] = "_";
            objectArray = objectArray2;
            objectArray2[2] = ESCAPE_SYMBOL;
        }
        Object[] unescapedChars = objectArray;
        String[] escapedChars = (String[])ContainerUtil.map2Array((Object[])unescapedChars, String.class, (Function)new Function<String, String>(){

            public String fun(String s) {
                return JdbcNativeUtil.ESCAPE_SYMBOL + s;
            }
        });
        return (T)StringUtil.replace((String)s, (String[])unescapedChars, (String[])escapedChars);
    }

    private static void setBigInteger(@NotNull Rdbms rdbms, @NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setBigInteger"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setBigInteger"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setBigInteger"));
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)rdbms.code, (CharSequence)"DB2") || rdbms == Sybase.RDBMS || rdbms == Mssql.RDBMS) {
            statement.setObject(idx, value.longValue());
            return;
        }
        statement.setObject(idx, value, -5);
    }

    public static boolean isZonedColumn(@NotNull String typeName, @NotNull Rdbms rdbms) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedColumn"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedColumn"));
        }
        return JdbcNativeUtil.isZonedTimeColumn(typeName, rdbms) || JdbcNativeUtil.isZonedTimestampColumn(typeName, rdbms);
    }

    public static boolean isZonedTimestampColumn(@NotNull String typeName, @NotNull Rdbms rdbms) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimestampColumn"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimestampColumn"));
        }
        return JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && PG_TIMESTAMP_TZ_NAME.equals(typeName);
    }

    public static void closeRemoteStatementSafe(@Nullable RemoteStatement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static Object tryGetString(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "tryGetString"));
        }
        return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
    }

    public static boolean isZonedTimeColumn(@NotNull String typeName, @NotNull Rdbms rdbms) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimeColumn"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimeColumn"));
        }
        return JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && PG_TIME_TZ_NAME.equals(typeName);
    }

    private static boolean isPgUuidColumn(@NotNull String typeName, @NotNull Rdbms rdbms) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isPgUuidColumn"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isPgUuidColumn"));
        }
        return JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"uuid");
    }
}

